// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanContextualidentityMetrics_h
#define mozilla_GleanContextualidentityMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace containers {
  /**
   * generated from containers.container_created
   */
  struct ContainerCreatedExtra {
    mozilla::Maybe<nsCString> containerId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (containerId) {
        extraKeys.AppendElement()->AssignASCII("container_id");
        extraValues.EmplaceBack(containerId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user creates a new container.
   */
  constexpr impl::EventMetric<ContainerCreatedExtra> container_created(295);

  /**
   * generated from containers.container_deleted
   */
  struct ContainerDeletedExtra {
    mozilla::Maybe<nsCString> containerId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (containerId) {
        extraKeys.AppendElement()->AssignASCII("container_id");
        extraValues.EmplaceBack(containerId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user deletes a container.
   */
  constexpr impl::EventMetric<ContainerDeletedExtra> container_deleted(296);

  /**
   * generated from containers.container_modified
   */
  struct ContainerModifiedExtra {
    mozilla::Maybe<nsCString> containerId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (containerId) {
        extraKeys.AppendElement()->AssignASCII("container_id");
        extraValues.EmplaceBack(containerId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user edits a container (e.g. changes name, icon, or color).
   */
  constexpr impl::EventMetric<ContainerModifiedExtra> container_modified(297);

  /**
   * generated from containers.container_profile_loaded
   */
  struct ContainerProfileLoadedExtra {
    mozilla::Maybe<uint32_t> containers;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (containers) {
        extraKeys.AppendElement()->AssignASCII("containers");
        extraValues.AppendElement()->AppendInt(containers.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user profile is loaded and container definitions are read.
   */
  constexpr impl::EventMetric<ContainerProfileLoadedExtra> container_profile_loaded(298);

  /**
   * generated from containers.container_tab_closed
   */
  struct ContainerTabClosedExtra {
    mozilla::Maybe<nsCString> containerId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (containerId) {
        extraKeys.AppendElement()->AssignASCII("container_id");
        extraValues.EmplaceBack(containerId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a container tab is closed.
   */
  constexpr impl::EventMetric<ContainerTabClosedExtra> container_tab_closed(299);

  /**
   * generated from containers.container_tab_opened
   */
  struct ContainerTabOpenedExtra {
    mozilla::Maybe<nsCString> containerId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (containerId) {
        extraKeys.AppendElement()->AssignASCII("container_id");
        extraValues.EmplaceBack(containerId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a container tab is opened.
   */
  constexpr impl::EventMetric<ContainerTabOpenedExtra> container_tab_opened(300);

  /**
   * generated from containers.containers_enabled
   */
  struct ContainersEnabledExtra {
    mozilla::Maybe<bool> enabled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the container feature is enabled or disabled (pref privacy.userContext.enabled).
   */
  constexpr impl::EventMetric<ContainersEnabledExtra> containers_enabled(301);

  /**
   * generated from containers.tab_assigned_container
   */
  struct TabAssignedContainerExtra {
    mozilla::Maybe<nsCString> fromContainerId;
    mozilla::Maybe<nsCString> toContainerId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fromContainerId) {
        extraKeys.AppendElement()->AssignASCII("from_container_id");
        extraValues.EmplaceBack(fromContainerId.value());
      }
      if (toContainerId) {
        extraKeys.AppendElement()->AssignASCII("to_container_id");
        extraValues.EmplaceBack(toContainerId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a tab is moved into a container.
   */
  constexpr impl::EventMetric<TabAssignedContainerExtra> tab_assigned_container(302);
}

} // namespace mozilla::glean

#endif // mozilla_GleanContextualidentityMetrics_h
