/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ErrorEvent_h
#define mozilla_dom_ErrorEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/ErrorEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla::dom {

class ErrorEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(ErrorEvent, Event)

protected:
  virtual ~ErrorEvent();
  explicit ErrorEvent(mozilla::dom::EventTarget* aOwner);

  nsString mMessage;
  nsString mFilename;
  uint32_t mLineno;
  uint32_t mColno;
  JS::Heap<JS::Value> mError;

public:
  void
  GetError(JS::MutableHandle<JS::Value> aRetVal) const;

  ErrorEvent* AsErrorEvent() override;

  JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<ErrorEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ErrorEventInit& aEventInitDict);

  static already_AddRefed<ErrorEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ErrorEventInit& aEventInitDict);

  void GetMessage(nsString& aRetVal) const;

  void GetFilename(nsString& aRetVal) const;

  uint32_t Lineno() const;

  uint32_t Colno() const;

  void GetError(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const;
};

} // namespace mozilla::dom

#endif // mozilla_dom_ErrorEvent_h
