// Preferences to harden Firefox's security and privacy
// Do not edit this file.

// Use the OS locale by default (tor-browser#17400)
pref("intl.locale.requested", "");

// Home page is blank rather than Firefox Home (Activity Stream).
// tor-browser#31575 and tor-browser#30662
pref("browser.startup.homepage", "about:blank");

// tor-browser#43164: Prevent search-bar from being auto-hidden when not used for awhile
// This preference is locked so that the browser itself can never set an actual
// value that would trigger the migration.
pref("browser.search.widget.lastUsed", "", locked);

// Disable initial homepage notifications
pref("browser.search.update", false);
pref("startup.homepage_welcome_url", "");
pref("startup.homepage_welcome_url.additional", "");

// Disable Firefox Welcome Dialog
pref("browser.aboutwelcome.enabled", false);

#if MOZ_UPDATE_CHANNEL == release
// tor-browser#42640: Disable Firefox Flame button due to unknown interactions with New Identity
pref("browser.privatebrowsing.resetPBM.enabled", false, locked);
#endif

// Bug 41668: allow users to apply updates. This is set also in firefox.js for
// all platforms, except for Windows. As explained on firefox.js, Firefox uses a
// per-installation preference on Windows. However, we patch this behavior, and
// we set this preference also for Windows.
pref("app.update.auto", true);

// Try to nag a bit more about updates: Pop up a restart dialog an hour after the initial dialog
pref("app.update.promptWaitTime", 3600);

#ifndef XP_MACOSX
// Disable staged updates on platforms other than macOS.
// Staged updates do not work on Windows due to #18292.
// Also, on Windows and Linux any changes that are made to the browser profile
// or Tor data after an update is staged will be lost.
pref("app.update.staging.enabled", false);
#endif

pref("browser.startup.homepage_override.buildID", "20100101");

// Disable the "Refresh" prompt that is displayed for stale profiles.
pref("browser.disableResetPrompt", true);

// Disk activity: Disable Browsing History Storage
pref("browser.privatebrowsing.autostart", true);
pref("browser.cache.disk.enable", false);
pref("permissions.memory_only", true);
pref("security.nocertdb", true);
pref("media.aboutwebrtc.hist.enabled", false);

// Disk Activity

// Disable auto-downloading to ~/Downloads and other download tweaks to minimize
// disk leaks (tor-browser#42050).
pref("browser.download.useDownloadDir", false);
pref("browser.download.always_ask_before_handling_new_types", true);
pref("browser.download.manager.addToRecentDocs", false);
pref("browser.download.start_downloads_in_tmp_dir", true);
// tor-browser#42147: Always delete temporary files, also on macOS (this pref is
// already true for other platforms).
// Also, this always happens in PBM. If not in PBM, requires
// browser.download.start_downloads_in_tmp_dir to be true too.
pref("browser.helperApps.deleteTempFileOnExit", true);

// Prevent download stuffing / DOS (tor-browser#41764)
pref("browser.download.enable_spam_prevention", true);

// tor-browser#41131: This is normally gated on
// privacy.sanitize.sanitizeOnShutdown, which is false by default. But in case
// users enable it, make sure background tasks are not used for this, since we
// disable them as well (but at compile time).
pref("network.cache.shutdown_purge_in_background_task", false);

// Misc privacy: Disk
pref("signon.rememberSignons", false, locked);
pref("browser.formfill.enable", false, locked);
pref("signon.formlessCapture.enabled", false); // Added with tor-browser#41496
pref("signon.autofillForms", false, locked);
// NOTE: extensions.formautofill.available is a legacy preference that upstream
// has not removed yet, and is only used for a migration to the newer
// "*.supported" preferences. See bugzilla bug 1745248.
pref("extensions.formautofill.available", "");
// Suppress formautofill component. tor-browser#44460.
// NOTE: With the "formautofill" built-in extension removed from Base Browser
// builds, some of these preferences have almost no effect at the time of
// implementation, but we include them in case they help with future-proofing.
pref("extensions.formautofill.addresses.supported", "off");
pref("extensions.formautofill.addresses.experiments.enabled", false);
pref("extensions.formautofill.addresses.enabled", false);
pref("extensions.formautofill.creditCards.supported", "off");
pref("extensions.formautofill.creditCards.enabled", false);
// Do not store extra data (form, scrollbar positions, cookies, POST data) for
// the session restore functionality.
pref("browser.sessionstore.privacy_level", 2);
// Use the in-memory media cache and increase its maximum size (#29120)
pref("browser.privatebrowsing.forceMediaMemoryCache", true);
pref("media.memory_cache_max_size", 65536);
// tor-browser#41065: lie about the available quota.
// This value is in KiB, and will be divided by 5. Currently: 50GiB, to be
// coherent with Firefox's usual value. However, this might be too much for live
// systems.
// This will be the limit also after granting the persistent storage permission,
// but we are not interested in it, since we support only PBM.
// We can come back to it, and hardcode the two spaced differently, if we ever
// think we need it.
pref("dom.quotaManager.temporaryStorage.fixedLimit", 52428800);
// Disable restore in case of crash (tor-browser#41503)
// This should not be needed in PBM, but we added it anyway like other options.
pref("browser.sessionstore.resume_from_crash", false);
// Disable capturing thumbnails (tor-browser#41595)
// Also not needed in PBM at the moment.
pref("browser.pagethumbnails.capturing_disabled", true);
// tor-browser#41988: Remove page titles from window titles to prevent possible
// disk leaks, e.g., in system logs.
// For example, it happened that GNOME shell logged the window name that caused
// JS errors/unexpected conditions for unrelated issues.
// TODO: commented out for now because of UX concerns, to be reconsidered in 14.5
// pref("privacy.exposeContentTitleInWindow", false);
// pref("privacy.exposeContentTitleInWindow.pbm", false);

// tor-browser#42054: Opt-out from any built-in backup system, even though
// local, as it might be a violation of our standalone mode.
// Users can still opt-in if they wish.
pref("browser.backup.enabled", false);
pref("browser.backup.scheduled.enabled", false);

// Empty clipboard content from private windows on exit (tor-browser#42154)
pref("browser.privatebrowsing.preserveClipboard", false);

// tor-browser#42611: Do not include the URL of the image, when copying it.
// Also, do not save clipboard in history/cloud.
pref("clipboard.imageAsFile.enabled", false);
pref("clipboard.copyPrivateDataToClipboardCloudOrHistory", false);

// Enable HTTPS-Only mode (tor-browser#19850)
pref("dom.security.https_only_mode", true);
// The previous pref automatically sets this to true (see StaticPrefList.yaml),
// but set it anyway only as a defense-in-depth.
pref("dom.security.https_only_mode_pbm", true);
// tor-browser#43197, defense in depth if ever https-only got disabled
pref("dom.security.https_first_add_exception_on_failure", false);

// tor-browser#22320: Hide referer when coming from a .onion address
// We enable this here (rather than in Tor Browser) in case users of other
// base-browser derived browsers configure it to use a system Tor daemon
// to visit onion services.
pref("network.http.referer.hideOnionSource", true);

// Require Safe Negotiation ( https://gitlab.torproject.org/tpo/applications/tor-browser/-/issues/27719 )
// Blocks connections to servers that don't support RFC 5746 [2] as they're potentially vulnerable to a
// MiTM attack [3]. A server without RFC 5746 can be safe from the attack if it disables renegotiations
// but the problem is that the browser can't know that. Setting this pref to true is the only way for the
// browser to ensure there will be no unsafe renegotiations on the channel between the browser and the server
// [STATS] SSL Labs (July 2021) reports over 99% of top sites have secure renegotiation [4]
// [1] https://wiki.mozilla.org/Security:Renegotiation
// [2] https://datatracker.ietf.org/doc/html/rfc5746
// [3] https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-3555
// [4] https://www.ssllabs.com/ssl-pulse/
pref("security.ssl.require_safe_negotiation", true);

// lock those disabled by https://bugzilla.mozilla.org/show_bug.cgi?id=1036765
pref("security.ssl3.dhe_rsa_aes_128_sha", false, locked);
pref("security.ssl3.dhe_rsa_aes_256_sha", false, locked);

// Wrapping a static pref to lock it and prevent changing.
// See tor-browser#40565.
pref("security.tls.version.enable-deprecated", false, locked);

// tor-browser#44187: Disable session identifiers to make PBM and normal mode
// more similar.
pref("security.ssl.disable_session_identifiers", true);

// Misc privacy: Remote
pref("browser.send_pings", false);
// Space separated list of URLs that are allowed to send objects (instead of
// only strings) through webchannels. The default for Firefox is some Mozilla
// domains.
pref("webchannel.allowObject.urlWhitelist", "");
pref("geo.enabled", false);
pref("geo.provider.network.url", "");
pref("geo.provider.ms-windows-location", false);
pref("geo.provider.use_corelocation", false);
pref("geo.provider.use_gpsd", false);
pref("geo.provider.use_geoclue", false);
pref("browser.search.suggest.enabled", false);
pref("browser.search.suggest.enabled.private", false);
pref("browser.urlbar.suggest.searches", false);
pref("browser.urlbar.suggest.quicksuggest.nonsponsored", false);
pref("browser.urlbar.suggest.quicksuggest.sponsored", false);
// tor-browser#41576: Do not suggest weather and addons.
pref("browser.urlbar.suggest.addons", false);
pref("browser.urlbar.addons.featureGate", false);
pref("browser.urlbar.suggest.weather", false);
pref("browser.urlbar.weather.featureGate", false);
// tor-browser#42886: Disable trending results.
pref("browser.urlbar.suggest.trending", false);
pref("browser.urlbar.trending.featureGate", false);
// tor-browser#42792: Explicitly turn off Pocket suggestions in the URL bar.
pref("browser.urlbar.pocket.featureGate", false);
// tor-browser#41691: Hide "Firefox Suggest" in the UI
pref("browser.urlbar.groupLabels.enabled", false);
pref("browser.safebrowsing.malware.enabled", false);
pref("browser.safebrowsing.phishing.enabled", false);
pref("browser.safebrowsing.downloads.enabled", false);
pref("browser.safebrowsing.downloads.remote.enabled", false);
pref("browser.safebrowsing.blockedURIs.enabled", false);
pref("browser.safebrowsing.downloads.remote.url", "");
pref("browser.safebrowsing.provider.google.updateURL", "");
pref("browser.safebrowsing.provider.google.gethashURL", "");
pref("browser.safebrowsing.provider.google4.updateURL", "");
pref("browser.safebrowsing.provider.google4.gethashURL", "");
pref("browser.safebrowsing.provider.mozilla.updateURL", "");
pref("browser.safebrowsing.provider.mozilla.gethashURL", "");
// tor-browser#42735: Disable recent search suggestions
pref("browser.urlbar.recentsearches.featureGate", false);
pref("browser.urlbar.suggest.recentsearches", false);

// tor-browser#44262: Disable adding search engines from HTML forms
pref("browser.urlbar.update2.engineAliasRefresh", false);

// Disable the UITour API
// See tor-browser#41457 and
// https://bugzilla.mozilla.org/show_bug.cgi?id=1915280
pref("browser.uitour.enabled", false);

// Make sure Unified Telemetry is really disabled, see: #18738.
pref("toolkit.telemetry.unified", false);
// This needs to be locked, or nightly builds will automatically lock it to true
pref("toolkit.telemetry.enabled", false, locked);
pref("toolkit.telemetry.server", "data:,");
pref("toolkit.telemetry.archive.enabled", false);
pref("toolkit.telemetry.newProfilePing.enabled", false); // Added in tor-browser#41496
pref("toolkit.telemetry.shutdownPingSender.enabled", false); // Added in tor-browser#41496
pref("toolkit.telemetry.firstShutdownPing.enabled", false); // Added in tor-browser#41496
pref("toolkit.telemetry.updatePing.enabled", false); // Make sure updater telemetry is disabled; see #25909.
pref("toolkit.telemetry.bhrPing.enabled", false);
pref("toolkit.telemetry.coverage.opt-out", true);
pref("datareporting.healthreport.uploadEnabled", false);
pref("datareporting.policy.dataSubmissionEnabled", false);
// Force all telemtry identifier to their canary values tor-browser#43750
pref("toolkit.telemetry.cachedClientID", "c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0", locked);
pref("toolkit.telemetry.cachedProfileGroupID", "decafdec-afde-cafd-ecaf-decafdecafde", locked);
pref("datareporting.dau.cachedUsageProfileID", "beefbeef-beef-beef-beef-beeefbeefbee", locked);
pref("datareporting.dau.cachedUsageProfileGroupID", "b0bacafe-b0ba-cafe-b0ba-cafeb0bacafe", locked);
pref("toolkit.coverage.opt-out", true);
pref("toolkit.coverage.endpoint.base", "");
pref("browser.tabs.crashReporting.sendReport", false);
pref("browser.crashReports.unsubmittedCheck.autoSubmit2", false);
// Added in tor-browser#41496 even though false by default
pref("browser.crashReports.unsubmittedCheck.enabled", false);
// tor-browser#44026: Disable the modal that shows upstream terms of usage,
// since we opt out of their telemetry and data collection.
pref("browser.preonboarding.enabled", false);
// Disable checkbox in about:neterror that controls
// security.xfocsp.errorReporting.automatic. See tor-browser#42653.
pref("security.xfocsp.errorReporting.enabled", false);
// Added in tor-browser#41496 even though it shuld be already always disabled
// since we disable MOZ_CRASHREPORTER.
pref("breakpad.reportURL", "data:");
// tor-browser#43985: Disable captcha detector code that is just used upstream
// for identifying captchas with the purpose of sending telemetry about it.
pref("captchadetection.actor.enabled", false);
#ifdef XP_WIN
// Defense-in-depth: ensure that the Windows default browser agent will
// not ping Mozilla if it is somehow present (we omit it at build time).
pref("default-browser-agent.enabled", false);
#endif
// Disable sync by default
pref("identity.fxaccounts.enabled", false);
// Blank the sync URL as a defense in depth (added with tor-browser#41496)
pref("identity.sync.tokenserver.uri", "");
// Never sync with other browsers
pref("services.sync.engine.addons", false);
pref("services.sync.engine.addresses", false);
pref("services.sync.engine.bookmarks", false);
pref("services.sync.engine.creditcards", false);
pref("services.sync.engine.history", false);
pref("services.sync.engine.passwords", false);
pref("services.sync.engine.prefs", false);
pref("services.sync.engine.tabs", false);
pref("extensions.getAddons.cache.enabled", false); // https://blog.mozilla.org/addons/how-to-opt-out-of-add-on-metadata-updates/
pref("privacy.donottrackheader.enabled", false); // (mullvad-browser#17)
// Make sure there is no Tracking Protection active in Tor Browser, see: #17898.
pref("privacy.trackingprotection.enabled", false);
pref("privacy.trackingprotection.pbmode.enabled", false);
pref("privacy.trackingprotection.emailtracking.pbmode.enabled", false);
pref("privacy.trackingprotection.annotate_channels", false);
pref("privacy.trackingprotection.cryptomining.enabled", false);
pref("privacy.trackingprotection.fingerprinting.enabled", false);
pref("privacy.trackingprotection.socialtracking.enabled", false);
// tor-browser#43986: Explicitly disable bounce tracking protection
pref("privacy.bounceTrackingProtection.mode", 0);
pref("privacy.socialtracking.block_cookies.enabled", false);
pref("privacy.annotate_channels.strict_list.enabled", false);
// tor-browser#43178: for defense-in-depth, avoid remote overrides to FPP.
// Notice that it should not apply to RFP anyway...
pref("privacy.fingerprintingProtection.remoteOverrides.enabled", false);

// Disable the Pocket extension (Bug #18886 and #31602)
pref("extensions.pocket.enabled", false);

// Disable Privacy-Preserving-Attribution (Bug #42687)
pref("dom.private-attribution.submission.enabled", false);

// Custom extensions preferences tor-browser#41581
pref("extensions.hideNoScript", true);
pref("extensions.hideUnifiedWhenEmpty", true);

// Disable activity stream/"Recommended by Pocket" in about:home (Bug #41029)
pref("browser.newtabpage.activity-stream.discoverystream.enabled", false);
pref("browser.newtabpage.activity-stream.feeds.section.topstories", false);
pref("browser.newtabpage.activity-stream.showSponsored", false);
pref("browser.newtabpage.activity-stream.showSponsoredTopSites", false);
pref("browser.newtabpage.activity-stream.default.sites", "");
// Activity Stream telemetry
pref("browser.newtabpage.activity-stream.feeds.telemetry", false);
pref("browser.newtabpage.activity-stream.telemetry", false);

// tor-browser#40788: disable AS's calls to home.
// Notice that null is between quotes because it is a JSON string.
// Keep checked firefox.js to see if new entries are added.
pref("browser.newtabpage.activity-stream.asrouter.providers.cfr", "null");
pref("browser.newtabpage.activity-stream.asrouter.providers.message-groups", "null");
pref("browser.newtabpage.activity-stream.asrouter.providers.messaging-experiments", "null");

// Disable fetching asrouter.ftl and related console errors (tor-browser#40763).
pref("browser.newtabpage.activity-stream.asrouter.useRemoteL10n", false);

// tor-browser#42054: make sure search result telemetry is disabled.
pref("browser.search.serpEventTelemetryCategorization.enabled", false);



// ML components that we want to hide from the user. See tor-browser#44045.
// Many of these preferences are locked because the component is entirely
// removed, so they could not be functionally enabled.

// tor-browser#42872, #42555, #44045: Disable ML translations.
// Maybe re-enable after auditing and fixing the UX (tor-browser#41837).
// NOTE: whilst the "translations" component is still included in the build, we
// lock the preference because the engine is excluded and the
// "translations-models" RemoteSettings needed for the engine is empty.
pref("browser.translations.enable", false, locked);
// Disables many (but not all) ML engines. Note, this does not have overall
// control over exposure to ML features. tor-browser#44045.
pref("browser.ml.enable", false, locked);
// Disable third party AI chatbot. tor-browser#43989.
pref("browser.ml.chat.enabled", false, locked);
// Disable LinkPreview. tor-browser#44045 and tor-browser#43867.
pref("browser.ml.linkPreview.enabled", false, locked);
// Disable Smart Tab Groups. tor-browser#44045.
pref("browser.tabs.groups.smart.enabled", false, locked);
pref("browser.tabs.groups.smart.userEnabled", false, locked);
// Don't expose ModelHub API for extensions. tor-browser#44045.
pref("extensions.ml.enabled", false, locked);
// Don't enable ML generated alt text. tor-browser#44045.
// pdfjs.enableAltText controls whether MLManager is created,
// pdfjs.enableGuessAltText controls whether the MLManager can create an ML
// engine. pdfs.enableAltText controls whether the latter preference can be
// changed by the user in the UI, but also has the side effect of hiding the
// UI controls for the non-ML preference pdfjs.enableNewAltTextWhenAddingImage.
// See bugzilla bug 1943456 comment 12.
pref("pdfjs.enableAltText", false, locked);
pref("pdfjs.enableAltTextForEnglish", false, locked);
pref("pdfjs.enableGuessAltText", false, locked);
pref("pdfjs.enableAltTextModelDownload", false, locked);
// Disable SuggestBackendMl. tor-browser#44045.
pref("browser.urlbar.quicksuggest.mlEnabled", false, locked);
// Disable SemanticHistory search. tor-browser#44045.
pref("places.semanticHistory.featureGate", false, locked);


// tor-browser#41945 - disable automatic cookie banners dismissal until
// we're sure it does not causes fingerprinting risks or other issues.
pref("cookiebanners.service.mode", 0);
pref("cookiebanners.service.mode.privateBrowsing", 0);
pref("cookiebanners.ui.desktop.enabled", false);

// Disable moreFromMozilla pane in the preferences/settings (tor-browser#41292).
pref("browser.preferences.moreFromMozilla", false);

// Disable webcompat reporter
pref("extensions.webcompat-reporter.enabled", false);

// Disable Content Analysis SDK (tor-browser#42364)
pref("browser.contentanalysis.enabled", false);
pref("browser.contentanalysis.default_result", 0);

// Disable contentRelevancy component (which itself is gated on Nimbus) (tor-browser#42867)
pref("toolkit.contentRelevancy.enabled", false);
pref("toolkit.contentRelevancy.ingestEnabled", false);
pref("toolkit.contentRelevancy.log", false);

pref("browser.search.region", "US"); // Disable GeoIP search lookups (#16254)
// Disable use of WiFi location information
pref("browser.region.network.scan", false);
pref("browser.region.network.url", "");
pref("browser.region.local-geocoding", false);
// Bug 40083: Make sure Region.sys.mjs fetching is disabled
pref("browser.region.update.enabled", false);

// Don't load Mozilla domains in a separate privileged tab process
pref("browser.tabs.remote.separatePrivilegedMozillaWebContentProcess", false);
pref("browser.tabs.remote.separatedMozillaDomains", "");

// Avoid DNS lookups on search terms
pref("browser.urlbar.dnsResolveSingleWordsAfterSearch", 0);

// Disable about:newtab and "first run" experiments
pref("messaging-system.rsexperimentloader.enabled", false);
// true means that you are *not* opting out. See its usage in various file.
pref("app.shield.optoutstudies.enabled", false);
// Disable Normandy/Shield
pref("app.normandy.enabled", false);
pref("app.normandy.api_url", "");

// [SETTING] General>Browsing>Recommend extensions as you browse (Bug #40700)
pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.addons", false); // disable CFR [FF67+]

// [SETTING] General>Browsing>Recommend features as you browse (Bug #40700)
pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features", false); // disable CFR [FF67+]

// Clear the list of trusted recursive resolver services
pref("network.trr.default_provider_uri", "");

// Disable the /etc/hosts parser
// If true, entries from /etc/hosts will be excluded **from TRR results**.
// Vice-versa, if it is false, TRR will override any /etc/hosts customization.
pref("network.trr.exclude-etc-hosts", false);

// Disable crlite
pref("security.remote_settings.crlite_filters.enabled", false);
pref("security.pki.crlite_mode", 0);

// Disable website password breach alerts
pref("signon.management.page.breach-alerts.enabled", false, locked);
// tor-browser#42814: Opt out from Firefox relay by default.
// Firefox would normally assign disabled when a user has been presented the
// opportunity to use the service and opted out (see firefox.js).
pref("signon.firefoxRelay.feature", "disabled");

// Disable remote "password recipes". They are a way to improve the UX of the
// password manager by havinc specific heuristics for some sites.
// It needs remote settings and in general we disable the password manager.
// More information about this feature at
// https://bugzilla.mozilla.org/show_bug.cgi?id=1119454
pref("signon.recipes.remoteRecipes.enabled", false);

// Disable ServiceWorkers by default. They do not work in PBM in any case.
// See https://bugzilla.mozilla.org/show_bug.cgi?id=1320796
pref("dom.serviceWorkers.enabled", false);
// Push notifications use an online Mozilla service and a persistent ID stored
// in dom.push.userAgentID, so disable them by default.
// See also https://support.mozilla.org/kb/push-notifications-firefox
pref("dom.push.enabled", false);
// As a defense in depth measure, also set the push server URL to empty.
// See tor-browser#18801.
pref("dom.push.serverURL", "");

// Fingerprinting
// tor-browser#41797: For release builds, lock RFP
// tor-browser#42125: Set (and lock in release) also exempted domains.
#if MOZ_UPDATE_CHANNEL == release
pref("privacy.resistFingerprinting", true, locked);
pref("privacy.resistFingerprinting.exemptedDomains", "", locked);
// tor-browser#42125: Some misleading guides suggest to set this to false, but
// the result would be that the canvas is completely white
// (see StaticPrefList.yaml), so lock it to true.
// Might be removed (MozBug 1670447).
pref("privacy.resistFingerprinting.randomDataOnCanvasExtract", true, locked);
#else
pref("privacy.resistFingerprinting", true);
pref("privacy.resistFingerprinting.exemptedDomains", "");
#endif
// tor-browser#43904: Enable this so we skip the blank window if user is resisting fingerprinting.
pref("privacy.resistFingerprinting.skipEarlyBlankFirstPaint", true);
// tor-browser#18603: failIfMajorPerformanceCaveat is an optional attribute that
// can be used when creating a WebGL context if the browser detects that the
// performance would be low. That could be used to fingerpting users with a not
// good graphics card, so disable it (actually, defense in depth, it is already
// disabled by default from Firefox).
pref("webgl.disable-fail-if-major-performance-caveat", true);
// tor-browser#16404: disable until we investigate it further (#22333)
pref("webgl.enable-webgl2", false);
pref("browser.link.open_newwindow.restriction", 0); // Bug 9881: Open popups in new tabs (to avoid fullscreen popups)
// tor-browser#42767: Disable offscreen canvas until verified it is not fingerprintable
pref("gfx.offscreencanvas.enabled", false);
// Prevent scripts from moving and resizing open windows
pref("dom.disable_window_move_resize", true);
// Set video VP9 to 0 for everyone (bug 22548)
pref("media.benchmark.vp9.threshold", 0);
// tor-browser#43950: Disable HEVC, as it will reveal lacking hardware support,
// or differences in installed codec for Linux systems.
pref("media.hevc.enabled", false);
pref("privacy.resistFingerprinting.block_mozAddonManager", true); // Bug 26114
pref("dom.webmidi.enabled", false); // Bug 41398: Disable Web MIDI API
// tor-browser#42043: Stop reporting device IDs (and spoof their number without
// RFP, RFP already reports 1 audioinput and 1 videoinput, but still has
// randomized IDs when this pref is true).
// Defense-in-depth (already the default value) from Firefox 119 or 120.
pref("media.devices.enumerate.legacy.enabled", false);
#ifndef ANDROID
// Bug 42138: Disable touch-based overscroll UX
pref("apz.overscroll.enabled", false);
#endif
pref("dom.vr.enabled", false); // Bug 21607: Disable WebVR for now
pref("security.webauth.webauthn", false); // Bug 26614: Disable Web Authentication API for now
// Disable SAB, no matter if the sites are cross-origin isolated.
pref("dom.postMessage.sharedArrayBuffer.withCOOP_COEP", false);
// Disable intermediate preloading (Bug 30682)
pref("security.remote_settings.intermediates.enabled", false);
// Bug 2874: Block Components.interfaces from content
pref("dom.use_components_shim", false);
// Enable letterboxing
pref("privacy.resistFingerprinting.letterboxing", true);
// tor-browser#41917: Center letterboxed area vertically
pref("privacy.resistFingerprinting.letterboxing.vcenter", true);
// tor-browser#41917: Letterboxing gradient background
pref("privacy.resistFingerprinting.letterboxing.gradient", true);
// tor-browser#41918: Should we reuse last window sizes if letterboxing is enabled
pref("privacy.resistFingerprinting.letterboxing.rememberSize", false);
// tor-browser#41695: How many warnings we show if user closes them without restoring the window size
pref("privacy.resistFingerprinting.resizeWarnings", 3);
// tor-browser#43402: Avoid a resize from the skeleton to the newwin size.
// Should be fixed in ESR-140 with Bug 1448423.
pref("browser.startup.blankWindow", false);
// Enforce Network Information API as disabled
pref("dom.netinfo.enabled", false);
pref("network.http.referer.defaultPolicy", 2); // Bug 32948: Make referer behavior consistent regardless of private browing mode status
pref("network.http.referer.defaultPolicy.pbmode", 2);
pref("network.http.referer.XOriginTrimmingPolicy", 2); // Bug 17228: Force trim referer to scheme+host+port in cross-origin requests
// Bug 40463: Disable Windows SSO
pref("network.http.windows-sso.enabled", false, locked);
// Bug 43165: Disable Microsoft SSO on macOS
pref("network.http.microsoft-entra-sso.enabled", false);
pref("network.microsoft-sso-authority-list", "");
// tor-browser#40424
pref("pdfjs.enableScripting", false);
#if MOZ_UPDATE_CHANNEL == release
// tor-browser#42255: pdfjs.disabled used to be part of RFP until Bug 1838415; lock pref to false in stable
pref("pdfjs.disabled", false, locked);
#endif
// tor-browser#43850. Keep forced colors off by default for all platforms.
// Upstream sets a value of "0" for Windows.
pref("browser.display.document_color_use", 1);
// Bug 40057: Ensure system colors are not used for CSS4 colors.
// FIXME: This preference seems to be unread since bugzilla bug 1898096, but
// still exists in the static preference list. Remove when upstream removes
// this or confirms it will not be used again in the future.
pref("browser.display.use_system_colors", false);
// tor-browser#43366: do not use system accent color in inputs.
// See also https://bugzilla.mozilla.org/show_bug.cgi?id=1861362.
pref("widget.non-native-theme.use-theme-accent", false);
// tor-browser#43236: Disable vsync on Wayland to prevent refresh rate leaks.
pref("widget.wayland.vsync.enabled", false);

// tor-browser#41943: defense-in-depth, but do not lock anymore (enabled in Firefox 119, http://bugzil.la/1851162)
pref("javascript.options.spectre.disable_for_isolated_content", false);

// Third party stuff
pref("privacy.firstparty.isolate", true); // Always enforce first party isolation
// tor-browser#40123 and #40308: Disable for now until audit
pref("privacy.partition.network_state", false);
// Only accept cookies from the originating site (block third party cookies)
pref("network.cookie.cookieBehavior", 1);
pref("network.cookie.cookieBehavior.pbmode", 1);
pref("network.predictor.enabled", false); // Temporarily disabled. See https://bugs.torproject.org/16633
pref("network.predictor.enable-prefetch", false);
pref("network.http.speculative-parallel-limit", 0);
pref("browser.places.speculativeConnect.enabled", false);
pref("network.prefetch-next", false);
pref("browser.urlbar.speculativeConnect.enabled", false);
// Bug 40220: Make sure tracker cookie purging is disabled.
// It depends on Firefox's tracking protection, which we currently do not enable
// See also tor-browser#30939.
pref("privacy.purge_trackers.enabled", false);
// Do not allow cross-origin sub-resources to open HTTP authentication
// credentials dialogs. Hardens against potential credentials phishing.
pref("network.auth.subresource-http-auth-allow", 1);

// tor-browser#42684: Disable network prefetch
pref("network.dns.disablePrefetch", true);
pref("network.dns.disablePrefetchFromHTTPS", true);
pref("dom.prefetch_dns_for_anchor_http_document", false);
pref("dom.prefetch_dns_for_anchor_https_document", false);

pref("network.protocol-handler.external-default", false);
pref("network.protocol-handler.external.mailto", false);
pref("network.protocol-handler.external.news", false);
pref("network.protocol-handler.external.nntp", false);
pref("network.protocol-handler.external.snews", false);
pref("network.protocol-handler.warn-external.mailto", true);
pref("network.protocol-handler.warn-external.news", true);
pref("network.protocol-handler.warn-external.nntp", true);
pref("network.protocol-handler.warn-external.snews", true);
#ifdef XP_WIN
  pref("network.protocol-handler.external.ms-windows-store", false);
  pref("network.protocol-handler.warn-external.ms-windows-store", true);
#endif
pref("network.proxy.allow_bypass", false, locked); // #40682
// Bug 40548: Disable proxy-bypass
pref("network.proxy.failover_direct", false, locked);
// Lock to 'true', which is already the firefox default, to prevent users
// from making themselves fingerprintable by disabling. This pref
// alters content load order in a page. See tor-browser#24686
pref("network.http.tailing.enabled", true, locked);

// Block 0.0.0.0
// https://bugzilla.mozilla.org/show_bug.cgi?id=1889130
// tor-browser#43811
pref("network.socket.ip_addr_any.disabled", true);

// tor-browser#23044: Make sure we don't have any GIO supported protocols
// (defense in depth measure).
// As of Firefox 118 (Bug 1843763), upstream does not add any protocol by
// default, but setting it to blank seems a good idea (tor-browser#42054).
pref("network.gio.supported-protocols", "");
// Mullvad Browser enables WebRTC by default, meaning that there the following prefs
// are first-line defense, rather than "in depth" (mullvad-browser#40)
// tor-browser#41667 - Defense in depth: use mDNS to avoid local IP leaks on Android too if user enables WebRTC
pref("media.peerconnection.ice.obfuscate_host_addresses", true);
// tor-browser#41671 - Defense in depth: connect using TURN only, to avoid IP leaks if user enables WebRTC
pref("media.peerconnection.ice.relay_only", true);
// tor-browser#42029 - Defense-in-depth: disable non-proxied UDP WebRTC
pref("media.peerconnection.ice.default_address_only", true);
pref("media.peerconnection.ice.no_host", true);
pref("media.peerconnection.ice.proxy_only_if_behind_proxy", true);

// GMPs (Gecko Media Plugins, https://wiki.mozilla.org/GeckoMediaPlugins)
// We make sure they don't show up on the Add-on panel and confuse users.
// And the external update/donwload server must not get pinged. We apply a
// clever solution for https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=769716.
// See tor-browser#15910.
pref("media.gmp-provider.enabled", false);
pref("media.gmp-manager.url.override", "data:text/plain,");
// Since ESR52 it is not enough anymore to block pinging the GMP update/download
// server. There is a local fallback that must be blocked now as well. See:
// https://bugzilla.mozilla.org/show_bug.cgi?id=1267495.
pref("media.gmp-manager.updateEnabled", false);
// Mozilla is relying on preferences to make sure no DRM blob is downloaded and
// run. Even though those prefs should be set correctly by specifying
// --disable-eme (which we do), we disable all of them here as well for defense
// in depth (see bug 16285 for more details).
pref("browser.eme.ui.enabled", false);
pref("media.gmp-widevinecdm.visible", false);
pref("media.gmp-widevinecdm.enabled", false);
pref("media.eme.enabled", false);
pref("media.mediadrm-widevinecdm.visible", false);
// The in-browser debugger for debugging chrome code is not coping with our
// restrictive DNS look-up policy. We use "127.0.0.1" instead of "localhost" as
// a workaround. See bug 16523 for more details.
pref("devtools.debugger.chrome-debugging-host", "127.0.0.1");
// Disable using UNC paths (bug 26424 and Mozilla's bug 1413868)
pref("network.file.disable_unc_paths", true);
// Enhance our treatment of file:// to avoid proxy bypasses (see Mozilla's bug
// 1412081 and CVE-2017-16541)
pref("network.file.path_blacklist", "/net");

// Security slider
pref("svg.disabled", false);
pref("mathml.disabled", false);

// Bug 40408
pref("svg.context-properties.content.allowed-domains", "");

// Network and performance
pref("security.ssl.enable_false_start", true);
// tor-browser#18945
pref("network.manage-offline-status", false);
// No need to leak things to Mozilla, see bug 21790 and tor-browser#40322
pref("network.captive-portal-service.enabled", false);
pref("network.connectivity-service.enabled", false);
pref("captivedetect.canonicalURL", "");

#ifdef XP_WIN
// tor-browser#41683: Disable the network process on Windows
// Mozilla already disables the network process for HTTP.
// With this preference, we completely disable it, because we found that it
// breaks stuff with mingw. See also tor-browser#41489.
pref("network.process.enabled", false);
#endif

// Extension support
pref("extensions.autoDisableScopes", 0);
// Only load extensions from the application and user profile.
// Do not load from the user directory (AddonManager.SCOPE_USER=2, which is
// shared between profiles, e.g., %appdata%\Mozilla\Extensions\ on Windows, or
// ~/.mozilla/extensions on Linux for Firefox), and do not load from system
// directories/the Windows registry (AddonManager.SCOPE_SYSTEM=8).
// More information: https://archive.ph/DYjAM
pref("extensions.enabledScopes", 5); // AddonManager.SCOPE_PROFILE=1 | AddonManager.SCOPE_APPLICATION=4
// We don't know what extensions Mozilla is advertising to our users and we
// don't want to have some random Google Analytics script running either on the
// about:addons page, see bug 22073, 22900 and 31601.
pref("extensions.getAddons.showPane", false);
pref("extensions.htmlaboutaddons.recommendations.enabled", false);
// Disable personalized Extension Recommendations in about:addons and
// addons.mozilla.org
pref("browser.discovery.enabled", false);
// tor-browser#26114: Allow NoScript to work on addons.mozilla.org and other Mozilla sites.
// Revisited and confirmed in tor-browser#41445.
pref("extensions.webextensions.restrictedDomains", "");
// Don't give Mozilla-recommended third-party extensions special privileges.
pref("extensions.postDownloadThirdPartyPrompt", false);
// tor-browser#41701: Reporting an extension does not work. The request goes to
// Mozilla and is always rejected anyway (HTTP 400).
pref("extensions.abuseReport.enabled", false);
// We are already providing the languages we support in multi-lingual packages.
// Therefore, do not allow download of additional language packs. They are not a
// privacy/security threat, we are disabling them for UX reasons. See bug 41377.
pref("intl.multilingual.downloadEnabled", false);

// Enforce certificate pinning, see: https://bugs.torproject.org/16206
pref("security.cert_pinning.enforcement_level", 2);

// Don't load OS client certs.
pref("security.osclientcerts.autoload", false);

// Don't allow MitM via enterprise roots, see bug 30681
pref("security.enterprise_roots.enabled", false);

// Don't ping Mozilla for MitM detection, see bug 32321
pref("security.certerrors.mitm.priming.enabled", false);

// Don't automatically enable enterprise roots, see bug 40166
pref("security.certerrors.mitm.auto_enable_enterprise_roots", false);

// Disable share menus on Mac and Windows tor-browser#41117
pref("browser.menu.share_url.allow", false, locked);

// Disable special URL bar behaviors
pref("browser.urlbar.suggest.topsites", false);
pref("browser.urlbar.quicksuggest.enabled", false);
pref("browser.urlbar.richSuggestions.featureGate", false);
pref("browser.urlbar.yelp.featureGate", false);
pref("browser.urlbar.mdn.featureGate", false);

// tor-browser#41884: Do not start a search when clicking on the new tab button
// with the middle mouse button (to prevent searching for anything you might
// have selected or already in your clipboard).
pref("browser.tabs.searchclipboardfor.middleclick", false);

// tor-browser#41417: do not allow live reload until we switch to Fluent and
// stop using .textContent.
// Even after that, it might be a good idea to keep it off, as it is not handled
// very well, and it might give a window during which websites could fingerprint
// the change (see tor-browser#42349 and tor-browser#42771).
pref("intl.multilingual.liveReload", false);

// Enable URL query stripping to protect against cross-site tracking (tor-browser#41092)
pref("privacy.query_stripping.enabled", true);
pref("privacy.query_stripping.enabled.pbmode", true);
pref("privacy.query_stripping.strip_on_share.enabled", true);

// Ensure global privacy control headers are consistent in private browsing and
// non-private browsing (tor-browser#42777).
pref("privacy.globalprivacycontrol.enabled", true);
pref("privacy.globalprivacycontrol.pbmode.enabled", true);

// Disable platform text recognition functionality (tor-browser#42057)
pref("dom.text-recognition.enabled", false);

// Log levels
pref("browser.new_identity.log_level", "Info");

#ifdef XP_WIN
pref("browser.taskbar.lists.enabled", false);
pref("browser.taskbar.lists.frequent.enabled", false);
pref("browser.taskbar.lists.tasks.enabled", false);
pref("browser.taskbar.lists.recent.enabled", false);

// tor-browser#41806: Prevent the browser from adding a new Private Browsing
// start menu item automatically
pref("browser.privacySegmentation.createdShortcut", true);

// Do not re-open the browser automatically after reboots when "Restart apps" is
// enabled (tor-browser#41503)
pref("toolkit.winRegisterApplicationRestart", false);
// tor-browser#43051: Hide the checkbox to open the browser automatically on
// Windows startup.
pref("browser.startup.windowsLaunchOnLogin.enabled", false);
#endif

#ifdef ANDROID
// tor-browser#43023 Force use of only standard emoji font
// (not actually stopping samsung emoji font detection, but defense in depth and a step towards normalization)
pref("font.name-list.emoji", "Noto Color Emoji");
#endif

// If we are bundling fonts, whitelist those bundled fonts, and restrict system fonts to a selection.

#ifdef MOZ_BUNDLED_FONTS

// Bug 40342: Always use bundled fonts
pref("gfx.bundled-fonts.activate", 1);

#ifdef XP_MACOSX
pref("font.system.whitelist", "AppleGothic, Apple Color Emoji, Arial, Arial Black, Arial Narrow, Courier, Courier New, Geneva, Georgia, Heiti TC, Helvetica, Helvetica Neue, Hiragino Kaku Gothic ProN, Kailasa, Lucida Grande, Menlo, Monaco, PingFang HK, PingFang SC, PingFang TC, Songti SC, Songti TC, Tahoma, Thonburi, Times, Times New Roman, Verdana, STIX Two Math, Noto Sans Adlam, Noto Sans Armenian, Noto Sans Balinese, Noto Sans Bamum, Noto Sans Bassa Vah, Noto Sans Batak, Noto Sans Bengali, Noto Sans Buginese, Noto Sans Buhid, Noto Sans Canadian Aboriginal, Noto Sans Chakma, Noto Sans Cham, Noto Sans Cherokee, Noto Sans Coptic, Noto Sans Deseret, Noto Sans Devanagari, Noto Sans Elbasan, Noto Sans Ethiopic, Noto Sans Georgian, Noto Sans Grantha, Noto Sans Gujarati, Noto Sans Gunjala Gondi, Noto Sans Gurmukhi, Noto Sans Hanifi Rohingya, Noto Sans Hanunoo, Noto Sans Hebrew, Noto Sans Kannada, Noto Sans Khmer, Noto Sans Javanese, Noto Sans Kayah Li, Noto Sans Khojki, Noto Sans Khudawadi, Noto Sans Lao, Noto Sans Lepcha, Noto Sans Limbu, Noto Sans Lisu, Noto Sans Mahajani, Noto Sans Malayalam, Noto Sans Mandaic, Noto Sans Masaram Gondi, Noto Sans Medefaidrin, Noto Sans Meetei Mayek, Noto Sans Mende Kikakui, Noto Sans Miao, Noto Sans Modi, Noto Sans Mongolian, Noto Sans Mro, Noto Sans Multani, Noto Sans Newa, Noto Sans New Tai Lue, Noto Sans NKo, Noto Sans Ol Chiki, Noto Sans Oriya, Noto Sans Osage, Noto Sans Osmanya, Noto Sans Pahawh Hmong, Noto Sans Pau Cin Hau, Noto Sans Rejang, Noto Sans Runic, Noto Sans Samaritan, Noto Sans Saurashtra, Noto Sans Sharada, Noto Sans Shavian, Noto Sans Sinhala, Noto Sans Sora Sompeng, Noto Sans Soyombo, Noto Sans Sundanese, Noto Sans Syloti Nagri, Noto Sans Symbols 2, Noto Sans Symbols, Noto Sans Syriac, Noto Sans Tagalog, Noto Sans Tagbanwa, Noto Sans Tai Le, Noto Sans Tai Tham, Noto Sans Tai Viet, Noto Sans Takri, Noto Sans Tamil, Noto Sans Telugu, Noto Sans Thaana, Noto Sans Tifinagh Adrar, Noto Sans Tifinagh Agraw Imazighen, Noto Sans Tifinagh Ahaggar, Noto Sans Tifinagh Air, Noto Sans Tifinagh APT, Noto Sans Tifinagh Azawagh, Noto Sans Tifinagh Ghat, Noto Sans Tifinagh Hawad, Noto Sans Tifinagh, Noto Sans Tifinagh Rhissa Ixa, Noto Sans Tifinagh SIL, Noto Sans Tifinagh Tawellemmet, Noto Sans Tirhuta, Noto Sans Vai, Noto Sans Wancho, Noto Sans Warang Citi, Noto Sans Yi, Noto Sans Zanabazar Square, Noto Serif Armenian, Noto Serif Balinese, Noto Serif Bengali, Noto Serif Devanagari, Noto Serif Dogra, Noto Serif Ethiopic, Noto Serif Georgian, Noto Serif Grantha, Noto Serif Gujarati, Noto Serif Gurmukhi, Noto Serif Hebrew, Noto Serif Kannada, Noto Serif Khmer, Noto Serif Khojki, Noto Serif Lao, Noto Serif Malayalam, Noto Serif Myanmar, Noto Serif NP Hmong, Noto Serif Sinhala, Noto Serif Tamil, Noto Serif Telugu, Noto Serif Tibetan, Noto Serif Yezidi, Pyidaungsu");

// Armenian
pref("font.name-list.serif.x-armn", "Noto Serif Armenian, Times, Times New Roman");
pref("font.name-list.sans-serif.x-armn", "Noto Sans Armenian, Helvetica, Arial");
pref("font.name-list.monospace.x-armn", "Noto Sans Armenian, Menlo, Courier New");
// Bengali
pref("font.name-list.serif.x-beng", "Noto Serif Bengali, Times, Times New Roman");
pref("font.name-list.sans-serif.x-beng", "Noto Sans Bengali, Helvetica, Arial");
pref("font.name-list.monospace.x-beng", "Noto Sans Bengali, Menlo, Courier New");
// Canadian Aboriginal
pref("font.name-list.serif.x-cans", "Noto Serif Canadian Aboriginal, Times, Times New Roman");
pref("font.name-list.sans-serif.x-cans", "Noto Sans Canadian Aboriginal, Helvetica, Arial");
pref("font.name-list.monospace.x-cans", "Noto Sans Canadian Aboriginal, Menlo, Courier New");
// ChineseCN
pref("font.name-list.serif.zh-CN", "Songti SC, Times, Times New Roman");
pref("font.name-list.sans-serif.zh-CN", "PingFang SC, Helvetica, Arial");
pref("font.name-list.monospace.zh-CN", "PingFang SC, Menlo, Courier New");
// ChineseHK
pref("font.name-list.serif.zh-HK", "Songti TC, Times, Times New Roman");
pref("font.name-list.sans-serif.zh-HK", "PingFang HK, Helvetica, Arial");
pref("font.name-list.monospace.zh-HK", "PingFang HK, Menlo, Courier New");
// ChineseTW
pref("font.name-list.serif.zh-TW", "Songti TC, Times, Times New Roman");
pref("font.name-list.sans-serif.zh-TW", "PingFang TC, Helvetica, Arial");
pref("font.name-list.monospace.zh-TW", "PingFang TC, Menlo, Courier New");
// Devanagari
pref("font.name-list.serif.x-devanagari", "Noto Serif Devanagari, Times, Times New Roman");
pref("font.name-list.sans-serif.x-devanagari", "Noto Sans Devanagari, Helvetica, Arial");
pref("font.name-list.monospace.x-devanagari", "Noto Sans Devanagari, Menlo, Courier New");
// Ethiopic
pref("font.name-list.serif.x-ethi", "Noto Serif Ethiopic, Times, Times New Roman");
pref("font.name-list.sans-serif.x-ethi", "Noto Sans Ethiopic, Helvetica, Arial");
pref("font.name-list.monospace.x-ethi", "Noto Sans Ethiopic, Menlo, Courier New");
// Georgian
pref("font.name-list.serif.x-geor", "Noto Serif Georgian, Times, Times New Roman");
pref("font.name-list.sans-serif.x-geor", "Noto Sans Georgian, Helvetica, Arial");
pref("font.name-list.monospace.x-geor", "Noto Sans Georgian, Menlo, Courier New");
// Gujarati
pref("font.name-list.serif.x-gujr", "Noto Serif Gujarati, Times, Times New Roman");
pref("font.name-list.sans-serif.x-gujr", "Noto Sans Gujarati, Helvetica, Arial");
pref("font.name-list.monospace.x-gujr", "Noto Sans Gujarati, Menlo, Courier New");
// Gurmukhi
pref("font.name-list.serif.x-guru", "Noto Serif Gurmukhi, Times, Times New Roman");
pref("font.name-list.sans-serif.x-guru", "Noto Sans Gurmukhi, Helvetica, Arial");
pref("font.name-list.monospace.x-guru", "Noto Sans Gurmukhi, Menlo, Courier New");
// Hebrew
pref("font.name-list.serif.he", "Noto Serif Hebrew, Times, Times New Roman");
pref("font.name-list.sans-serif.he", "Noto Sans Hebrew, Helvetica, Arial");
pref("font.name-list.monospace.he", "Noto Sans Hebrew, Menlo, Courier New");
// Kannada
pref("font.name-list.serif.x-knda", "Noto Serif Kannada, Times, Times New Roman");
pref("font.name-list.sans-serif.x-knda", "Noto Sans Kannada, Helvetica, Arial");
pref("font.name-list.monospace.x-knda", "Noto Sans Kannada, Menlo, Courier New");
// Khmer
pref("font.name-list.serif.x-khmr", "Noto Serif Khmer, Times, Times New Roman");
pref("font.name-list.sans-serif.x-khmr", "Noto Sans Khmer, Helvetica, Arial");
pref("font.name-list.monospace.x-khmr", "Noto Sans Khmer, Menlo, Courier New");
// Malayalam
pref("font.name-list.serif.x-mlym", "Noto Serif Malayalam, Times, Times New Roman");
pref("font.name-list.sans-serif.x-mlym", "Noto Sans Malayalam, Helvetica, Arial");
pref("font.name-list.monospace.x-mlym", "Noto Sans Malayalam, Menlo, Courier New");
// Mathematics
pref("font.name-list.serif.x-math", "STIX Two Math, Times, Times New Roman");
pref("font.name-list.sans-serif.x-math", "STIX Two Math, Helvetica, Arial");
pref("font.name-list.monospace.x-math", "STIX Two Math, Menlo, Courier New");
// Oriya
pref("font.name-list.serif.x-orya", "Noto Sans Oriya, Times, Times New Roman");
pref("font.name-list.sans-serif.x-orya", "Noto Sans Oriya, Helvetica, Arial");
pref("font.name-list.monospace.x-orya", "Noto Sans Oriya, Menlo, Courier New");
// Sinhala
pref("font.name-list.serif.x-sinh", "Noto Serif Sinhala, Times, Times New Roman");
pref("font.name-list.sans-serif.x-sinh", "Noto Sans Sinhala, Helvetica, Arial");
pref("font.name-list.monospace.x-sinh", "Noto Sans Sinhala, Menlo, Courier New");
// Tamil
pref("font.name-list.serif.x-tamil", "Noto Serif Tamil, Times, Times New Roman");
pref("font.name-list.sans-serif.x-tamil", "Noto Sans Tamil, Helvetica, Arial");
pref("font.name-list.monospace.x-tamil", "Noto Sans Tamil, Menlo, Courier New");
// Telugu
pref("font.name-list.serif.x-telu", "Noto Serif Telugu, Times, Times New Roman");
pref("font.name-list.sans-serif.x-telu", "Noto Sans Telugu, Helvetica, Arial");
pref("font.name-list.monospace.x-telu", "Noto Sans Telugu, Menlo, Courier New");
// Tibetan
pref("font.name-list.serif.x-tibt", "Noto Serif Tibetan, Times, Times New Roman");
pref("font.name-list.sans-serif.x-tibt", "Noto Serif Tibetan, Helvetica, Arial");
pref("font.name-list.monospace.x-tibt", "Noto Serif Tibetan, Menlo, Courier New");
// Others (Balinese, Grantha, Khojki, Lao, Myanmar)
pref("font.name-list.serif.x-unicode", "Times, Times New Roman, Noto Serif Balinese, Noto Serif Grantha, Noto Serif Khojki, Noto Serif Lao, Noto Serif Myanmar");
pref("font.name-list.sans-serif.x-unicode", "Helvetica, Arial, Noto Sans Balinese, Noto Sans Grantha, Noto Sans Khojki, Noto Sans Lao, Pyidaungsu");
pref("font.name-list.monospace.x-unicode", "Menlo, Courier New, Noto Sans Balinese, Noto Sans Grantha, Noto Sans Khojki, Noto Sans Lao, Pyidaungsu");
// The rest are not customized, because they are covered only by one font
#endif

#ifdef XP_WIN
pref("font.system.whitelist", "Arial, Cambria Math, Consolas, Courier New, Georgia, Lucida Console, MS Gothic, ＭＳ ゴシック, MS PGothic, ＭＳ Ｐゴシック, MV Boli, Malgun Gothic, Microsoft Himalaya, Microsoft JhengHei, Microsoft YaHei, 微软雅黑, Segoe UI, SimSun, 宋体, Sylfaen, Tahoma, Times New Roman, Verdana, Noto Sans Adlam, Noto Sans Balinese, Noto Sans Bamum, Noto Sans Bassa Vah, Noto Sans Batak, Noto Sans Bengali, Noto Sans Buginese, Noto Sans Buhid, Noto Sans Canadian Aboriginal, Noto Sans Chakma, Noto Sans Cham, Noto Sans Cherokee, Noto Sans Coptic, Noto Sans Deseret, Noto Sans Devanagari, Noto Sans Elbasan, Noto Sans Ethiopic, Noto Sans Georgian, Noto Sans Grantha, Noto Sans Gujarati, Noto Sans Gunjala Gondi, Noto Sans Gurmukhi, Noto Sans Hanifi Rohingya, Noto Sans Hanunoo, Noto Sans Kannada, Noto Sans Khmer, Noto Sans Javanese, Noto Sans Kayah Li, Noto Sans Khojki, Noto Sans Khudawadi, Noto Sans Lao, Noto Sans Lepcha, Noto Sans Limbu, Noto Sans Lisu, Noto Sans Mahajani, Noto Sans Malayalam, Noto Sans Mandaic, Noto Sans Masaram Gondi, Noto Sans Medefaidrin, Noto Sans Meetei Mayek, Noto Sans Mende Kikakui, Noto Sans Miao, Noto Sans Modi, Noto Sans Mongolian, Noto Sans Mro, Noto Sans Multani, Noto Sans Newa, Noto Sans New Tai Lue, Noto Sans NKo, Noto Sans Ol Chiki, Noto Sans Oriya, Noto Sans Osage, Noto Sans Osmanya, Noto Sans Pahawh Hmong, Noto Sans Pau Cin Hau, Noto Sans Rejang, Noto Sans Runic, Noto Sans Samaritan, Noto Sans Saurashtra, Noto Sans Sharada, Noto Sans Shavian, Noto Sans Sinhala, Noto Sans Sora Sompeng, Noto Sans Soyombo, Noto Sans Sundanese, Noto Sans Syloti Nagri, Noto Sans Symbols 2, Noto Sans Symbols, Noto Sans Syriac, Noto Sans Tagalog, Noto Sans Tagbanwa, Noto Sans Tai Le, Noto Sans Tai Tham, Noto Sans Tai Viet, Noto Sans Takri, Noto Sans Tamil, Noto Sans Telugu, Noto Sans Thaana, Noto Sans Tifinagh Adrar, Noto Sans Tifinagh Agraw Imazighen, Noto Sans Tifinagh Ahaggar, Noto Sans Tifinagh Air, Noto Sans Tifinagh APT, Noto Sans Tifinagh Azawagh, Noto Sans Tifinagh Ghat, Noto Sans Tifinagh Hawad, Noto Sans Tifinagh, Noto Sans Tifinagh Rhissa Ixa, Noto Sans Tifinagh SIL, Noto Sans Tifinagh Tawellemmet, Noto Sans Tirhuta, Noto Sans Vai, Noto Sans Wancho, Noto Sans Warang Citi, Noto Sans Yi, Noto Sans Zanabazar Square, Noto Serif Balinese, Noto Serif Bengali, Noto Serif Devanagari, Noto Serif Dogra, Noto Serif Ethiopic, Noto Serif Georgian, Noto Serif Grantha, Noto Serif Gujarati, Noto Serif Gurmukhi, Noto Serif Kannada, Noto Serif Khmer, Noto Serif Khojki, Noto Serif Lao, Noto Serif Malayalam, Noto Serif Myanmar, Noto Serif NP Hmong, Noto Serif Sinhala, Noto Serif Tamil, Noto Serif Telugu, Noto Serif Tibetan, Noto Serif Yezidi, Noto Naskh Arabic, Noto Sans, Noto Serif, Pyidaungsu, Twemoji Mozilla");

pref("font.name-list.emoji", "Twemoji Mozilla");
// Arabic
pref("font.name-list.serif.ar", "Times New Roman, Noto Naskh Arabic");
pref("font.name-list.sans-serif.ar", "Segoe UI, Tahoma, Arial, Noto Naskh Arabic");
pref("font.name-list.monospace.ar", "Consolas, Noto Naskh Arabic");
// Bengali
pref("font.name-list.serif.x-beng", "Noto Serif Bengali, Times New Roman");
pref("font.name-list.sans-serif.x-beng", "Noto Sans Bengali, Arial");
pref("font.name-list.monospace.x-beng", "Noto Sans Bengali, Consolas");
// Canadian Aboriginal
pref("font.name-list.serif.x-cans", "Noto Serif Canadian Aboriginal, Times New Roman");
pref("font.name-list.sans-serif.x-cans", "Noto Sans Canadian Aboriginal, Arial");
pref("font.name-list.monospace.x-cans", "Noto Sans Canadian Aboriginal, Consolas");
// Cyrillic (we use Noto only for fallback, system fonts have a good coverage)
pref("font.name-list.serif.x-cyrillic", "Times New Roman, Noto Serif");
pref("font.name-list.sans-serif.x-cyrillic", "Arial, Noto Sans");
// Devanagari
pref("font.name-list.serif.x-devanagari", "Noto Serif Devanagari, Times New Roman");
pref("font.name-list.sans-serif.x-devanagari", "Noto Sans Devanagari, Arial");
pref("font.name-list.monospace.x-devanagari", "Noto Sans Devanagari, Consolas");
// Ethiopic
pref("font.name-list.serif.x-ethi", "Noto Serif Ethiopic, Times New Roman");
pref("font.name-list.sans-serif.x-ethi", "Noto Sans Ethiopic, Arial");
pref("font.name-list.monospace.x-ethi", "Noto Sans Ethiopic, Consolas");
// Georgian
pref("font.name-list.serif.x-geor", "Noto Serif Georgian, Times New Roman");
pref("font.name-list.sans-serif.x-geor", "Noto Sans Georgian, Arial");
pref("font.name-list.monospace.x-geor", "Noto Sans Georgian, Consolas");
// Gujarati
pref("font.name-list.serif.x-gujr", "Noto Serif Gujarati, Times New Roman");
pref("font.name-list.sans-serif.x-gujr", "Noto Sans Gujarati, Arial");
pref("font.name-list.monospace.x-gujr", "Noto Sans Gujarati, Consolas");
// Gurmukhi
pref("font.name-list.serif.x-guru", "Noto Serif Gurmukhi, Times New Roman");
pref("font.name-list.sans-serif.x-guru", "Noto Sans Gurmukhi, Arial");
pref("font.name-list.monospace.x-guru", "Noto Sans Gurmukhi, Consolas");
// Kannada
pref("font.name-list.serif.x-knda", "Noto Serif Kannada, Times New Roman");
pref("font.name-list.sans-serif.x-knda", "Noto Sans Kannada, Arial");
pref("font.name-list.monospace.x-knda", "Noto Sans Kannada, Consolas");
// Khmer
pref("font.name-list.serif.x-khmr", "Noto Serif Khmer, Times New Roman");
pref("font.name-list.sans-serif.x-khmr", "Noto Sans Khmer, Arial");
pref("font.name-list.monospace.x-khmr", "Noto Sans Khmer, Consolas");
// Malayalam
pref("font.name-list.serif.x-mlym", "Noto Serif Malayalam, Times New Roman");
pref("font.name-list.sans-serif.x-mlym", "Noto Sans Malayalam, Arial");
pref("font.name-list.monospace.x-mlym", "Noto Sans Malayalam, Consolas");
// Oriya
pref("font.name-list.serif.x-orya", "Noto Sans Oriya, Times New Roman");
pref("font.name-list.sans-serif.x-orya", "Noto Sans Oriya, Arial");
pref("font.name-list.monospace.x-orya", "Noto Sans Oriya, Consolas");
// Sinhala
pref("font.name-list.serif.x-sinh", "Noto Serif Sinhala, Times New Roman");
pref("font.name-list.sans-serif.x-sinh", "Noto Sans Sinhala, Arial");
pref("font.name-list.monospace.x-sinh", "Noto Sans Sinhala, Consolas");
// Tamil
pref("font.name-list.serif.x-tamil", "Noto Serif Tamil, Times New Roman");
pref("font.name-list.sans-serif.x-tamil", "Noto Sans Tamil, Arial");
pref("font.name-list.monospace.x-tamil", "Noto Sans Tamil, Consolas");
// Telugu
pref("font.name-list.serif.x-telu", "Noto Serif Telugu, Times New Roman");
pref("font.name-list.sans-serif.x-telu", "Noto Sans Telugu, Arial");
pref("font.name-list.monospace.x-telu", "Noto Sans Telugu, Consolas");
// Tibetan
pref("font.name-list.serif.x-tibt", "Microsoft Himalaya, Noto Serif Tibetan, Times New Roman");
pref("font.name-list.sans-serif.x-tibt", "Microsoft Himalaya, Noto Serif Tibetan, Arial");
pref("font.name-list.monospace.x-tibt", "Microsoft Himalaya, Noto Serif Tibetan, Consolas");
// Others (Balinese, Grantha, Khojki, Lao, Myanmar)
pref("font.name-list.serif.x-unicode", "Times New Roman, Noto Serif Balinese, Noto Serif Grantha, Noto Serif Khojki, Noto Serif Lao, Noto Serif Myanmar");
pref("font.name-list.sans-serif.x-unicode", "Arial, Noto Sans Balinese, Noto Sans Grantha, Noto Sans Khojki, Noto Sans Lao, Pyidaungsu");
pref("font.name-list.monospace.x-unicode", "Consolas, Noto Sans Balinese, Noto Sans Grantha, Noto Sans Khojki, Noto Sans Lao, Pyidaungsu");
// The rest are not customized, because they are covered only by one font
#endif

#ifdef XP_LINUX
pref("font.system.whitelist", "Arimo, Cousine, Noto Color Emoji, Noto Naskh Arabic, Noto Sans Adlam, Noto Sans Armenian, Noto Sans Balinese, Noto Sans Bamum, Noto Sans Bassa Vah, Noto Sans Batak, Noto Sans Bengali, Noto Sans Buginese, Noto Sans Buhid, Noto Sans Canadian Aboriginal, Noto Sans Chakma, Noto Sans Cham, Noto Sans Cherokee, Noto Sans Coptic, Noto Sans Deseret, Noto Sans Devanagari, Noto Sans Elbasan, Noto Sans Ethiopic, Noto Sans Georgian, Noto Sans Grantha, Noto Sans Gujarati, Noto Sans Gunjala Gondi, Noto Sans Gurmukhi, Noto Sans Hanifi Rohingya, Noto Sans Hanunoo, Noto Sans Hebrew, Noto Sans JP, Noto Sans Javanese, Noto Sans KR, Noto Sans Kannada, Noto Sans Kayah Li, Noto Sans Khmer, Noto Sans Khojki, Noto Sans Khudawadi, Noto Sans Lao, Noto Sans Lepcha, Noto Sans Limbu, Noto Sans Lisu, Noto Sans Mahajani, Noto Sans Malayalam, Noto Sans Mandaic, Noto Sans Masaram Gondi, Noto Sans Medefaidrin, Noto Sans Meetei Mayek, Noto Sans Mende Kikakui, Noto Sans Miao, Noto Sans Modi, Noto Sans Mongolian, Noto Sans Mro, Noto Sans Multani, Noto Sans NKo, Noto Sans New Tai Lue, Noto Sans Newa, Noto Sans Ol Chiki, Noto Sans Oriya, Noto Sans Osage, Noto Sans Osmanya, Noto Sans Pahawh Hmong, Noto Sans Pau Cin Hau, Noto Sans Rejang, Noto Sans Runic, Noto Sans SC, Noto Sans Samaritan, Noto Sans Saurashtra, Noto Sans Sharada, Noto Sans Shavian, Noto Sans Sinhala, Noto Sans Sora Sompeng, Noto Sans Soyombo, Noto Sans Sundanese, Noto Sans Syloti Nagri, Noto Sans Symbols, Noto Sans Symbols 2, Noto Sans Syriac, Noto Sans TC, Noto Sans Tagalog, Noto Sans Tagbanwa, Noto Sans Tai Le, Noto Sans Tai Tham, Noto Sans Tai Viet, Noto Sans Takri, Noto Sans Tamil, Noto Sans Telugu, Noto Sans Thaana, Noto Sans Thai, Noto Sans Tifinagh, Noto Sans Tifinagh APT, Noto Sans Tifinagh Adrar, Noto Sans Tifinagh Agraw Imazighen, Noto Sans Tifinagh Ahaggar, Noto Sans Tifinagh Air, Noto Sans Tifinagh Azawagh, Noto Sans Tifinagh Ghat, Noto Sans Tifinagh Hawad, Noto Sans Tifinagh Rhissa Ixa, Noto Sans Tifinagh SIL, Noto Sans Tifinagh Tawellemmet, Noto Sans Tirhuta, Noto Sans Vai, Noto Sans Wancho, Noto Sans Warang Citi, Noto Sans Yi, Noto Sans Zanabazar Square, Noto Serif Armenian, Noto Serif Balinese, Noto Serif Bengali, Noto Serif Devanagari, Noto Serif Dogra, Noto Serif Ethiopic, Noto Serif Georgian, Noto Serif Grantha, Noto Serif Gujarati, Noto Serif Gurmukhi, Noto Serif Hebrew, Noto Serif Kannada, Noto Serif Khmer, Noto Serif Khojki, Noto Serif Lao, Noto Serif Malayalam, Noto Serif Myanmar, Noto Serif NP Hmong, Noto Serif Sinhala, Noto Serif Tamil, Noto Serif Telugu, Noto Serif Thai, Noto Serif Tibetan, Noto Serif Yezidi, Pyidaungsu, STIX Two Math, Tinos, Twemoji Mozilla");

pref("font.name-list.emoji", "Noto Color Emoji, Twemoji Mozilla");
// Arabic
pref("font.name-list.serif.ar", "Noto Naskh Arabic, Tinos");
pref("font.name-list.sans-serif.ar", "Noto Naskh Arabic, Arimo");
pref("font.name-list.monospace.ar", "Noto Naskh Arabic, Cousine");
// Armenian
pref("font.name-list.serif.x-armn", "Noto Serif Armenian, Tinos");
pref("font.name-list.sans-serif.x-armn", "Noto Sans Armenian, Arimo");
pref("font.name-list.sans-serif.x-armn", "Noto Sans Armenian, Cousine");
// Bengali
pref("font.name-list.serif.x-beng", "Noto Serif Bengali, Tinos");
pref("font.name-list.sans-serif.x-beng", "Noto Sans Bengali, Arimo");
pref("font.name-list.monospace.x-beng", "Noto Sans Bengali, Cousine");
// Canadian Aboriginal
pref("font.name-list.serif.x-cans", "Noto Serif Canadian Aboriginal, Tinos");
pref("font.name-list.sans-serif.x-cans", "Noto Sans Canadian Aboriginal, Arimo");
pref("font.name-list.monospace.x-cans", "Noto Sans Canadian Aboriginal, Cousine");
// ChineseCN
pref("font.name-list.serif.zh-CN", "Noto Sans SC, Tinos");
pref("font.name-list.sans-serif.zh-CN", "Noto Sans SC, Arimo");
pref("font.name-list.monospace.zh-CN", "Noto Sans SC, Cousine");
// ChineseHK
pref("font.name-list.serif.zh-HK", "Noto Sans TC, Tinos");
pref("font.name-list.sans-serif.zh-HK", "Noto Sans TC, Arimo");
pref("font.name-list.monospace.zh-HK", "Noto Sans TC, Cousine");
// ChineseTW
pref("font.name-list.serif.zh-TW", "Noto Sans TC, Tinos");
pref("font.name-list.sans-serif.zh-TW", "Noto Sans TC, Arimo");
pref("font.name-list.monospace.zh-TW", "Noto Sans TC, Cousine");
// Cyrillic
pref("font.name-list.serif.x-cyrillic", "Tinos");
pref("font.name-list.sans-serif.x-cyrillic", "Arimo");
pref("font.name-list.monospace.x-cyrillic", "Cousine");
// Devanagari
pref("font.name-list.serif.x-devanagari", "Noto Serif Devanagari, Tinos");
pref("font.name-list.sans-serif.x-devanagari", "Noto Sans Devanagari, Arimo");
pref("font.name-list.monospace.x-devanagari", "Noto Sans Devanagari, Cousine");
// Ethiopic
pref("font.name-list.serif.x-ethi", "Noto Serif Ethiopic, Tinos");
pref("font.name-list.sans-serif.x-ethi", "Noto Sans Ethiopic, Arimo");
pref("font.name-list.monospace.x-ethi", "Noto Sans Ethiopic, Cousine");
// Georgian
pref("font.name-list.serif.x-geor", "Noto Serif Georgian, Tinos");
pref("font.name-list.sans-serif.x-geor", "Noto Sans Georgian, Arimo");
pref("font.name-list.monospace.x-geor", "Noto Sans Georgian, Cousine");
// Greek
pref("font.name-list.serif.el", "Tinos");
pref("font.name-list.sans-serif.el", "Arimo");
pref("font.name-list.monospace.el", "Cousine");
// Gujarati
pref("font.name-list.serif.x-gujr", "Noto Serif Gujarati, Tinos");
pref("font.name-list.sans-serif.x-gujr", "Noto Sans Gujarati, Arimo");
pref("font.name-list.monospace.x-gujr", "Noto Sans Gujarati, Cousine");
// Gurmukhi
pref("font.name-list.serif.x-guru", "Noto Serif Gurmukhi, Tinos");
pref("font.name-list.sans-serif.x-guru", "Noto Sans Gurmukhi, Arimo");
pref("font.name-list.monospace.x-guru", "Noto Sans Gurmukhi, Cousine");
// Hebrew
pref("font.name-list.serif.he", "Noto Serif Hebrew, Tinos");
pref("font.name-list.sans-serif.he", "Noto Sans Hebrew, Arimo");
pref("font.name-list.monospace.he", "Noto Sans Hebrew, Cousine");
// Japanese
pref("font.name-list.serif.ja", "Noto Sans JP, Tinos");
pref("font.name-list.sans-serif.ja", "Noto Sans JP, Arimo");
pref("font.name-list.monospace.ja", "Noto Sans JP, Cousine");
// Kannada
pref("font.name-list.serif.x-knda", "Noto Serif Kannada, Tinos");
pref("font.name-list.sans-serif.x-knda", "Noto Sans Kannada, Arimo");
pref("font.name-list.monospace.x-knda", "Noto Sans Kannada, Cousine");
// Khmer
pref("font.name-list.serif.x-khmr", "Noto Serif Khmer, Tinos");
pref("font.name-list.sans-serif.x-khmr", "Noto Sans Khmer, Arimo");
pref("font.name-list.monospace.x-khmr", "Noto Sans Khmer, Cousine");
// Korean
pref("font.name-list.serif.ko", "Noto Sans KR Regular");
pref("font.name-list.sans-serif.ko", "Noto Sans KR Regular");
pref("font.name-list.monospace.ko", "Noto Sans KR Regular");
// Malayalam
pref("font.name-list.serif.x-mlym", "Noto Serif Malayalam, Tinos");
pref("font.name-list.sans-serif.x-mlym", "Noto Sans Malayalam, Arimo");
pref("font.name-list.monospace.x-mlym", "Noto Sans Malayalam, Cousine");
// Mathematics
pref("font.name-list.serif.x-math", "STIX Two Math, Tinos");
pref("font.name-list.sans-serif.x-math", "STIX Two Math, Arimo");
pref("font.name-list.monospace.x-math", "STIX Two Math, Cousine");
// Oriya
pref("font.name-list.serif.x-orya", "Noto Sans Oriya, Tinos");
pref("font.name-list.sans-serif.x-orya", "Noto Sans Oriya, Arimo");
pref("font.name-list.monospace.x-orya", "Noto Sans Oriya, Cousine");
// Sinhala
pref("font.name-list.serif.x-sinh", "Noto Serif Sinhala, Tinos");
pref("font.name-list.sans-serif.x-sinh", "Noto Sans Sinhala, Arimo");
pref("font.name-list.monospace.x-sinh", "Noto Sans Sinhala, Cousine");
// Tamil
pref("font.name-list.serif.x-tamil", "Noto Serif Tamil, Tinos");
pref("font.name-list.sans-serif.x-tamil", "Noto Sans Tamil, Arimo");
pref("font.name-list.monospace.x-tamil", "Noto Sans Tamil, Cousine");
// Telugu
pref("font.name-list.serif.x-telu", "Noto Serif Telugu, Tinos");
pref("font.name-list.sans-serif.x-telu", "Noto Sans Telugu, Arimo");
pref("font.name-list.monospace.x-telu", "Noto Sans Telugu, Cousine");
// Thai
pref("font.name-list.serif.th", "Noto Serif Thai, Tinos");
pref("font.name-list.sans-serif.th", "Noto Sans Thai, Arimo");
pref("font.name-list.monospace.th", "Noto Sans Thai, Cousine");
// Tibetan
pref("font.name-list.serif.x-tibt", "Noto Serif Tibetan, Tinos");
pref("font.name-list.sans-serif.x-tibt", "Noto Serif Tibetan, Arimo");
pref("font.name-list.monospace.x-tibt", "Noto Serif Tibetan, Cousine");
// Western
pref("font.name-list.serif.x-western", "Tinos");
pref("font.name-list.sans-serif.x-western", "Arimo");
pref("font.name-list.monospace.x-western", "Cousine");
// Others (Balinese, Grantha, Khojki, Lao, Myanmar)
pref("font.name-list.serif.x-unicode", "Tinos, Noto Serif Balinese, Noto Serif Grantha, Noto Serif Khojki, Noto Serif Lao, Noto Serif Myanmar");
pref("font.name-list.sans-serif.x-unicode", "Arimo, Noto Sans Balinese, Noto Sans Grantha, Noto Sans Khojki, Noto Sans Lao, Pyidaungsu");
pref("font.name-list.monospace.x-unicode", "Cousine, Noto Sans Balinese, Noto Sans Grantha, Noto Sans Khojki, Noto Sans Lao, Pyidaungsu");
// The rest are not customized, because they are covered only by one font
#endif
#endif

// tor-browser#42630: Disable LaterRun.
//
// This preference is set in a few places in code. Even though it's locked,
// setting it will still change the value in `prefs.js`, but it will be ignored.
// If this is ever unlocked, the value in prefs.js will be used.
pref("browser.laterrun.enabled", false, locked);

// tor-browser#44123: Never trim the protocol off of URLs.
pref("browser.urlbar.trimURLs", false);
