/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

const path = require("path");
const config = require("../asrouter/webpack.base.config.js");
const webpack = require("webpack");
const absolute = relPath => path.join(__dirname, relPath);
const banner = `
NOTE: This file is generated by webpack from aboutwelcome.jsx
using the npm bundle task.
`;
module.exports = Object.assign({}, config(), {
  entry: absolute("content-src/aboutwelcome.jsx"),
  output: {
    path: absolute("content"),
    filename: "aboutwelcome.bundle.js",
  },
  externals: {
    react: "React",
    "react-dom": "ReactDOM",
  },
  plugins: [new webpack.BannerPlugin(banner)],
});
