/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.framework.util.JarFileX;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SecureAction {
    private static final ThreadLocal m_actions = new ThreadLocal(){

        public Object initialValue() {
            return new Actions();
        }
    };
    protected static transient int BUFSIZE = 4096;
    private AccessControlContext m_acc = null;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$HashMap;

    public SecureAction() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(0, null);
                this.m_acc = (AccessControlContext)AccessController.doPrivileged(actions);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        } else {
            this.m_acc = AccessController.getContext();
        }
    }

    public String getSystemProperty(String name, String def) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(21, name, def);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return System.getProperty(name, def);
    }

    public ClassLoader getParentClassLoader(ClassLoader loader) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(22, loader);
                return (ClassLoader)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return loader.getParent();
    }

    public ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(23);
                return (ClassLoader)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return ClassLoader.getSystemClassLoader();
    }

    public Class forName(String name) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(10, name);
                return (Class)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return Class.forName(name);
    }

    public URL createURL(String protocol, String host, int port, String path, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(4, protocol, host, new Integer(port), path, handler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new URL(protocol, host, port, path, handler);
    }

    public URL createURL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(5, context, spec, handler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new URL(context, spec, handler);
    }

    public Process exec(String command) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(7, command);
                return (Process)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return Runtime.getRuntime().exec(command);
    }

    public String getAbsolutePath(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(11, file);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.getAbsolutePath();
    }

    public boolean fileExists(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(8, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.exists();
    }

    public boolean isFileDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(9, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.isDirectory();
    }

    public boolean mkdir(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(30, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.mkdir();
    }

    public boolean mkdirs(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(29, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.mkdirs();
    }

    public File[] listDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(28, file);
                return (File[])AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.listFiles();
    }

    public boolean renameFile(File oldFile, File newFile) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(34, oldFile, newFile);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return oldFile.renameTo(newFile);
    }

    public InputStream getFileInputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(16, file);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new FileInputStream(file);
    }

    public OutputStream getFileOutputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(17, file);
                return (OutputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new FileOutputStream(file);
    }

    public InputStream getURLConnectionInputStream(URLConnection conn) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(24, conn);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return conn.getInputStream();
    }

    public boolean deleteFile(File target) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(6, target);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return target.delete();
    }

    public File createTempFile(String prefix, String suffix, File dir) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(3, prefix, suffix, dir);
                return (File)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return File.createTempFile(prefix, suffix, dir);
    }

    public URLConnection openURLConnection(URL url) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(33, url);
                return (URLConnection)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return url.openConnection();
    }

    public JarFileX openJAR(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(31, file);
                return (JarFileX)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new JarFileX(file);
    }

    public JarFileX openJAR(File file, boolean verify) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(32, file, verify ? Boolean.TRUE : Boolean.FALSE);
                return (JarFileX)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new JarFileX(file, verify);
    }

    public void startActivator(BundleActivator activator, BundleContext context) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(36, activator, context);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        } else {
            activator.start(context);
        }
    }

    public void stopActivator(BundleActivator activator, BundleContext context) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(37, activator, context);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        } else {
            activator.stop(context);
        }
    }

    public Policy getPolicy() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(20, null);
                return (Policy)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return Policy.getPolicy();
    }

    public void addURLToURLClassLoader(URL extension, ClassLoader loader) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(1, extension, loader);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else {
            Method addURL = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = SecureAction.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = SecureAction.class$("java.net.URL")) : class$java$net$URL);
            addURL.setAccessible(true);
            addURL.invoke((Object)loader, extension);
        }
    }

    public Constructor getConstructor(Class target, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(12, target, types);
            try {
                return (Constructor)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getConstructor(types);
    }

    public Constructor getDeclaredConstructor(Class target, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(13, target, types);
            try {
                return (Constructor)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getDeclaredConstructor(types);
    }

    public Method getMethod(Class target, String method, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(19, target, method, types);
            try {
                return (Method)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getMethod(method, types);
    }

    public Method getDeclaredMethod(Class target, String method, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(14, target, method, types);
            try {
                return (Method)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getDeclaredMethod(method, types);
    }

    public void setAccesssible(AccessibleObject ao) {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(35, ao);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw (RuntimeException)e.getException();
            }
        } else {
            ao.setAccessible(true);
        }
    }

    public Object invoke(Method method, Object target, Object[] params) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(27, method, target, params);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        method.setAccessible(true);
        return method.invoke(target, params);
    }

    public Object invokeDirect(Method method, Object target, Object[] params) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(26, method, target, params);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return method.invoke(target, params);
    }

    public Object invoke(Constructor constructor, Object[] params) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(25, constructor, params);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return constructor.newInstance(params);
    }

    public Object getDeclaredField(Class targetClass, String name, Object target) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(15, targetClass, name, target);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        Field field = targetClass.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(target);
    }

    public Object swapStaticFieldIfNotClass(Class targetClazz, Class targetType, Class condition, String lockName) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(38, targetClazz, targetType, condition, lockName);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return SecureAction._swapStaticFieldIfNotClass(targetClazz, targetType, condition, lockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _swapStaticFieldIfNotClass(Class targetClazz, Class targetType, Class condition, String lockName) throws Exception {
        Object lock = null;
        if (lockName != null) {
            try {
                Field lockField = targetClazz.getDeclaredField(lockName);
                lockField.setAccessible(true);
                lock = lockField.get(null);
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
        }
        if (lock == null) {
            lock = targetClazz;
        }
        Class clazz = lock;
        synchronized (clazz) {
            int i;
            Field[] fields = targetClazz.getDeclaredFields();
            Object result = null;
            for (i = 0; i < fields.length && result == null; ++i) {
                if (!Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType() != targetType) continue;
                fields[i].setAccessible(true);
                result = fields[i].get(null);
                if (result == null || condition != null && result.getClass().getName().equals(condition.getName())) continue;
                fields[i].set(null, null);
            }
            if (result != null) {
                if (condition == null || !result.getClass().getName().equals(condition.getName())) {
                    for (i = 0; i < fields.length; ++i) {
                        if (!Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType() != (class$java$util$Hashtable == null ? SecureAction.class$("java.util.Hashtable") : class$java$util$Hashtable)) continue;
                        fields[i].setAccessible(true);
                        Hashtable cache = (Hashtable)fields[i].get(null);
                        if (cache == null) continue;
                        cache.clear();
                    }
                }
                return result;
            }
        }
        return null;
    }

    public void flush(Class targetClazz, Object lock) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(40, targetClazz, lock);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else {
            SecureAction._flush(targetClazz, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _flush(Class targetClazz, Object lock) throws Exception {
        Object object = lock;
        synchronized (object) {
            Field[] fields = targetClazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Map cache;
                if (!Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType() != (class$java$util$Hashtable == null ? SecureAction.class$("java.util.Hashtable") : class$java$util$Hashtable) && fields[i].getType() != (class$java$util$HashMap == null ? SecureAction.class$("java.util.HashMap") : class$java$util$HashMap)) continue;
                fields[i].setAccessible(true);
                if (fields[i].getType() == (class$java$util$Hashtable == null ? SecureAction.class$("java.util.Hashtable") : class$java$util$Hashtable)) {
                    cache = (Hashtable)fields[i].get(null);
                    if (cache == null) continue;
                    ((Hashtable)cache).clear();
                    continue;
                }
                cache = (HashMap)fields[i].get(null);
                if (cache == null) continue;
                ((HashMap)cache).clear();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Actions
    implements PrivilegedExceptionAction {
        public static final int INITIALIZE_CONTEXT = 0;
        public static final int ADD_EXTENSION_URL = 1;
        public static final int CREATE_MODULECLASSLOADER_ACTION = 2;
        public static final int CREATE_TMPFILE_ACTION = 3;
        public static final int CREATE_URL_ACTION = 4;
        public static final int CREATE_URL_WITH_CONTEXT_ACTION = 5;
        public static final int DELETE_FILE_ACTION = 6;
        public static final int EXEC_ACTION = 7;
        public static final int FILE_EXISTS_ACTION = 8;
        public static final int FILE_IS_DIRECTORY_ACTION = 9;
        public static final int FOR_NAME_ACTION = 10;
        public static final int GET_ABSOLUTE_PATH_ACTION = 11;
        public static final int GET_CONSTRUCTOR_ACTION = 12;
        public static final int GET_DECLARED_CONSTRUCTOR_ACTION = 13;
        public static final int GET_DECLARED_METHOD_ACTION = 14;
        public static final int GET_FIELD_ACTION = 15;
        public static final int GET_FILE_INPUT_ACTION = 16;
        public static final int GET_FILE_OUTPUT_ACTION = 17;
        public static final int GET_METHOD_ACTION = 19;
        public static final int GET_POLICY_ACTION = 20;
        public static final int GET_PROPERTY_ACTION = 21;
        public static final int GET_PARENT_CLASS_LOADER_ACTION = 22;
        public static final int GET_SYSTEM_CLASS_LOADER_ACTION = 23;
        public static final int GET_URL_INPUT_ACTION = 24;
        public static final int INVOKE_CONSTRUCTOR_ACTION = 25;
        public static final int INVOKE_DIRECTMETHOD_ACTION = 26;
        public static final int INVOKE_METHOD_ACTION = 27;
        public static final int LIST_DIRECTORY_ACTION = 28;
        public static final int MAKE_DIRECTORIES_ACTION = 29;
        public static final int MAKE_DIRECTORY_ACTION = 30;
        public static final int OPEN_JARX_ACTION = 31;
        public static final int OPEN_JARX_VERIFY_ACTION = 32;
        public static final int OPEN_URLCONNECTION_ACTION = 33;
        public static final int RENAME_FILE_ACTION = 34;
        public static final int SET_ACCESSIBLE_ACTION = 35;
        public static final int START_ACTIVATOR_ACTION = 36;
        public static final int STOP_ACTIVATOR_ACTION = 37;
        public static final int SWAP_FIELD_ACTION = 38;
        public static final int SYSTEM_EXIT_ACTION = 39;
        public static final int FLUSH_FIELD_ACTION = 40;
        private int m_action = -1;
        private Object m_arg1 = null;
        private Object m_arg2 = null;
        private Object m_arg3 = null;
        private Object m_arg4 = null;
        private Object m_arg5 = null;

        private Actions() {
        }

        public void set(int action) {
            this.m_action = action;
        }

        public void set(int action, Object arg1) {
            this.m_action = action;
            this.m_arg1 = arg1;
        }

        public void set(int action, Object arg1, Object arg2) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
        }

        public void set(int action, Object arg1, Object arg2, Object arg3) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_arg3 = arg3;
        }

        public void set(int action, Object arg1, Object arg2, Object arg3, Object arg4) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_arg3 = arg3;
            this.m_arg4 = arg4;
        }

        public void set(int action, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_arg3 = arg3;
            this.m_arg4 = arg4;
            this.m_arg5 = arg5;
        }

        private void unset() {
            this.m_action = -1;
            this.m_arg1 = null;
            this.m_arg2 = null;
            this.m_arg3 = null;
            this.m_arg4 = null;
            this.m_arg5 = null;
        }

        public Object run() throws Exception {
            int action = this.m_action;
            Object arg1 = this.m_arg1;
            Object arg2 = this.m_arg2;
            Object arg3 = this.m_arg3;
            Object arg4 = this.m_arg4;
            Object arg5 = this.m_arg5;
            this.unset();
            if (action == 0) {
                return AccessController.getContext();
            }
            if (action == 21) {
                return System.getProperty((String)arg1, (String)arg2);
            }
            if (action == 22) {
                return ((ClassLoader)arg1).getParent();
            }
            if (action == 23) {
                return ClassLoader.getSystemClassLoader();
            }
            if (action == 10) {
                return Class.forName((String)arg1);
            }
            if (action == 4) {
                return new URL((String)arg1, (String)arg2, (Integer)arg3, (String)arg4, (URLStreamHandler)arg5);
            }
            if (action == 5) {
                return new URL((URL)arg1, (String)arg2, (URLStreamHandler)arg3);
            }
            if (action == 7) {
                return Runtime.getRuntime().exec((String)arg1);
            }
            if (action == 11) {
                return ((File)arg1).getAbsolutePath();
            }
            if (action == 8) {
                return ((File)arg1).exists() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 9) {
                return ((File)arg1).isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 30) {
                return ((File)arg1).mkdir() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 29) {
                return ((File)arg1).mkdirs() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 28) {
                return ((File)arg1).listFiles();
            }
            if (action == 34) {
                return ((File)arg1).renameTo((File)arg2) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 16) {
                return new FileInputStream((File)arg1);
            }
            if (action == 17) {
                return new FileOutputStream((File)arg1);
            }
            if (action == 6) {
                return ((File)arg1).delete() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 31) {
                return new JarFileX((File)arg1);
            }
            if (action == 32) {
                return new JarFileX((File)arg1, (boolean)((Boolean)arg2));
            }
            if (action == 24) {
                return ((URLConnection)arg1).getInputStream();
            }
            if (action == 36) {
                ((BundleActivator)arg1).start((BundleContext)arg2);
                return null;
            }
            if (action == 37) {
                ((BundleActivator)arg1).stop((BundleContext)arg2);
                return null;
            }
            if (action == 39) {
                System.exit((Integer)arg1);
            } else {
                if (action == 20) {
                    return Policy.getPolicy();
                }
                if (action == 3) {
                    return File.createTempFile((String)arg1, (String)arg2, (File)arg3);
                }
                if (action == 33) {
                    return ((URL)arg1).openConnection();
                }
                if (action == 1) {
                    Method addURL = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = SecureAction.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = SecureAction.class$("java.net.URL")) : class$java$net$URL);
                    addURL.setAccessible(true);
                    addURL.invoke(arg2, arg1);
                } else {
                    if (action == 12) {
                        return ((Class)arg1).getConstructor((Class[])arg2);
                    }
                    if (action == 13) {
                        return ((Class)arg1).getDeclaredConstructor((Class[])arg2);
                    }
                    if (action == 19) {
                        return ((Class)arg1).getMethod((String)arg2, (Class[])arg3);
                    }
                    if (action == 27) {
                        ((Method)arg1).setAccessible(true);
                        return ((Method)arg1).invoke(arg2, (Object[])arg3);
                    }
                    if (action == 26) {
                        return ((Method)arg1).invoke(arg2, (Object[])arg3);
                    }
                    if (action == 25) {
                        return ((Constructor)arg1).newInstance((Object[])arg2);
                    }
                    if (action == 38) {
                        return SecureAction._swapStaticFieldIfNotClass((Class)arg1, (Class)arg2, (Class)arg3, (String)arg4);
                    }
                    if (action == 15) {
                        Field field = ((Class)arg1).getDeclaredField((String)arg2);
                        field.setAccessible(true);
                        return field.get(arg3);
                    }
                    if (action == 14) {
                        return ((Class)arg1).getDeclaredMethod((String)arg2, (Class[])arg3);
                    }
                    if (action == 35) {
                        ((AccessibleObject)arg1).setAccessible(true);
                    } else if (action == 40) {
                        SecureAction._flush((Class)arg1, arg2);
                    }
                }
            }
            return null;
        }
    }
}

