/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.util.Objects;

public class StandardComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardComparisonStrategy INSTANCE = new StandardComparisonStrategy();

    public static StandardComparisonStrategy instance() {
        return INSTANCE;
    }

    protected StandardComparisonStrategy() {
    }

    @Override
    protected Set<Object> newSetUsingComparisonStrategy() {
        return new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (StandardComparisonStrategy.this.areEqual(o1, o2)) {
                    return 0;
                }
                return Objects.hashCodeFor(o1) < Objects.hashCodeFor(o2) ? -1 : 1;
            }
        });
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        return Objects.areEqual(actual, other);
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return false;
        }
        for (Object next : iterable) {
            if (!this.areEqual(next, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (!this.areEqual(iterator.next(), value)) continue;
            iterator.remove();
        }
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    public boolean stringStartsWith(String string, String prefix) {
        return string.startsWith(prefix);
    }

    @Override
    public boolean stringEndsWith(String string, String suffix) {
        return string.endsWith(suffix);
    }

    @Override
    public boolean stringContains(String string, String sequence) {
        return string.contains(sequence);
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        if (!(actual instanceof Comparable)) {
            throw new IllegalArgumentException(String.format("argument '%s' should be Comparable but is not", actual));
        }
        return ((Comparable)Comparable.class.cast(actual)).compareTo(other) > 0;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        if (!(actual instanceof Comparable)) {
            throw new IllegalArgumentException(String.format("argument '%s' should be Comparable but is not", actual));
        }
        return ((Comparable)Comparable.class.cast(actual)).compareTo(other) < 0;
    }

    @Override
    public boolean isStandard() {
        return true;
    }
}

