/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class ByteArrays {
    private static final ByteArrays INSTANCE = new ByteArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static ByteArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    ByteArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public ByteArrays(ComparisonStrategy comparisonStrategy) {
        this.arrays = new Arrays(comparisonStrategy);
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, byte[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, byte[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, byte[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, byte[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info, byte[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, byte[] actual, byte value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, byte[] actual, byte value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, byte[] actual, byte[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, byte[] actual, byte[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info, byte[] actual, byte[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, byte[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, byte[] actual, byte[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, byte[] actual, byte[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info, byte[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, byte[] actual, Comparator<? super Byte> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }
}

