/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.xml;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.xml.StringToXmlDocumentParser;

public class XPathEvaluator
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final boolean namespaceAware;
    private final XPathExpression xPathExpression;
    private final StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();

    public XPathEvaluator(String expression, final Map<String, String> namespacePrefixes) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (namespacePrefixes != null) {
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if (namespacePrefixes.containsKey(prefix)) {
                        return (String)namespacePrefixes.get(prefix);
                    }
                    return "";
                }

                @Override
                public String getPrefix(String uri) {
                    throw new UnsupportedOperationException();
                }

                public Iterator getPrefixes(String uri) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        this.namespaceAware = namespacePrefixes != null;
        try {
            this.xPathExpression = xpath.compile(expression);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee.getMessage(), xpee);
        }
    }

    public Object evaluateXPathExpression(String xmlAsString, StringToXmlDocumentParser.ErrorLogger errorLogger, QName returnType) {
        try {
            return this.xPathExpression.evaluate(this.stringToXmlDocumentParser.buildDocument(xmlAsString, errorLogger, this.namespaceAware), returnType);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }
}

