/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.model.Header;
import org.mockserver.model.NottableString;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.NottableStringToJavaSerializer;

public class HeaderToJavaSerializer
implements MultiValueToJavaSerializer<Header> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Header header) {
        StringBuilder output = new StringBuilder();
        output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)(numberOfSpacesToIndent * 8), (char)' '));
        String serializedKey = NottableStringToJavaSerializer.serialize(header.getName(), false);
        output.append("new Header(").append(serializedKey);
        for (NottableString value : header.getValues()) {
            output.append(", ").append(NottableStringToJavaSerializer.serialize(value, serializedKey.endsWith(")")));
        }
        output.append(")");
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Header> headers) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < headers.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, headers.get(i)));
            if (i >= headers.size() - 1) continue;
            output.append(",");
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Header ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

