/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.ParameterStyle;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.JsonPathBodyDTO;
import org.mockserver.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.RegexBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XPathBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.mockserver.serialization.model.XmlSchemaBodyDTO;
import org.slf4j.event.Level;

public class BodyDTODeserializer
extends StdDeserializer<BodyDTO> {
    private static final Map<String, Body.Type> fieldNameToType = new HashMap<String, Body.Type>();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static ObjectWriter objectWriter;
    private static ObjectMapper objectMapper;
    private static ObjectWriter jsonBodyObjectWriter;
    private static final MockServerLogger MOCK_SERVER_LOGGER;

    public BodyDTODeserializer() {
        super(BodyDTO.class);
    }

    public BodyDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        BodyDTO result = null;
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        byte[] rawBytes = null;
        Enum type = null;
        Boolean not = null;
        Boolean optional = null;
        MediaType contentType = null;
        Charset charset = null;
        boolean subString = false;
        MatchType matchType = JsonBody.DEFAULT_MATCH_TYPE;
        Parameters parameters = null;
        HashMap<String, ParameterStyle> parameterStyles = null;
        HashMap<String, String> namespacePrefixes = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                String key;
                block77: {
                    block76: {
                        block75: {
                            block74: {
                                block73: {
                                    block72: {
                                        block71: {
                                            block70: {
                                                if (!(entry.getKey() instanceof String)) continue;
                                                key = (String)entry.getKey();
                                                if (key.equalsIgnoreCase("type")) {
                                                    try {
                                                        type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                                                    }
                                                    catch (IllegalArgumentException iae) {
                                                        if (!MockServerLogger.isEnabled(Level.DEBUG)) break block70;
                                                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring invalid value for \"type\" field of \"" + entry.getValue() + "\"").setThrowable(iae));
                                                    }
                                                }
                                            }
                                            if (this.containsIgnoreCase(key, "string", "regex", "json", "jsonSchema", "jsonPath", "xml", "xmlSchema", "xpath", "base64Bytes") && type != Body.Type.PARAMETERS) {
                                                String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                                                if (fieldNameToType.containsKey(fieldName)) {
                                                    type = fieldNameToType.get(fieldName);
                                                }
                                                if (Map.class.isAssignableFrom(entry.getValue().getClass()) || this.containsIgnoreCase(key, "json", "jsonSchema") && !String.class.isAssignableFrom(entry.getValue().getClass())) {
                                                    if (jsonBodyObjectWriter == null) {
                                                        jsonBodyObjectWriter = ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues().writerWithDefaultPrettyPrinter();
                                                    }
                                                    valueJsonValue = jsonBodyObjectWriter.writeValueAsString(entry.getValue());
                                                } else {
                                                    valueJsonValue = String.valueOf(entry.getValue());
                                                }
                                            }
                                            if (this.containsIgnoreCase(key, "rawBytes", "base64Bytes") && entry.getValue() instanceof String) {
                                                try {
                                                    rawBytes = BASE64_DECODER.decode((String)entry.getValue());
                                                }
                                                catch (Throwable throwable) {
                                                    if (!MockServerLogger.isEnabled(Level.DEBUG)) break block71;
                                                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("invalid base64 encoded rawBytes with value \"" + entry.getValue() + "\"").setThrowable(throwable));
                                                }
                                            }
                                        }
                                        if (key.equalsIgnoreCase("not")) {
                                            not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                                        }
                                        if (key.equalsIgnoreCase("optional")) {
                                            optional = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                                        }
                                        if (key.equalsIgnoreCase("matchType")) {
                                            try {
                                                matchType = MatchType.valueOf(String.valueOf(entry.getValue()));
                                            }
                                            catch (IllegalArgumentException iae) {
                                                if (!MockServerLogger.isEnabled(Level.DEBUG)) break block72;
                                                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring incorrect JsonBodyMatchType with value \"" + entry.getValue() + "\"").setThrowable(iae));
                                            }
                                        }
                                    }
                                    if (key.equalsIgnoreCase("subString")) {
                                        try {
                                            subString = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                                        }
                                        catch (IllegalArgumentException uce) {
                                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block73;
                                            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported boolean with value \"" + entry.getValue() + "\"").setThrowable(uce));
                                        }
                                    }
                                }
                                if (key.equalsIgnoreCase("parameterStyles") && entry.getValue() instanceof Map) {
                                    try {
                                        parameterStyles = new HashMap<String, ParameterStyle>();
                                        for (Map.Entry parameterStyle : ((Map)entry.getValue()).entrySet()) {
                                            parameterStyles.put(String.valueOf(parameterStyle.getKey()), ParameterStyle.valueOf(String.valueOf(parameterStyle.getValue())));
                                        }
                                    }
                                    catch (IllegalArgumentException uce) {
                                        if (!MockServerLogger.isEnabled(Level.DEBUG)) break block74;
                                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported boolean with value \"" + entry.getValue() + "\"").setThrowable(uce));
                                    }
                                }
                            }
                            if (key.equalsIgnoreCase("namespacePrefixes") && entry.getValue() instanceof Map) {
                                try {
                                    namespacePrefixes = new HashMap<String, String>();
                                    for (Map.Entry namespacePrefixEntry : ((Map)entry.getValue()).entrySet()) {
                                        namespacePrefixes.put(String.valueOf(namespacePrefixEntry.getKey()), String.valueOf(namespacePrefixEntry.getValue()));
                                    }
                                }
                                catch (IllegalArgumentException uce) {
                                    if (!MockServerLogger.isEnabled(Level.DEBUG)) break block75;
                                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported namespacePrefixEntry with value \"" + entry.getValue() + "\"").setThrowable(uce));
                                }
                            }
                        }
                        if (key.equalsIgnoreCase("contentType")) {
                            try {
                                MediaType parsedMediaTypeHeader;
                                String mediaTypeHeader = String.valueOf(entry.getValue());
                                if (StringUtils.isNotBlank((CharSequence)mediaTypeHeader) && StringUtils.isNotBlank((CharSequence)(parsedMediaTypeHeader = MediaType.parse(mediaTypeHeader)).toString())) {
                                    contentType = parsedMediaTypeHeader;
                                }
                            }
                            catch (IllegalArgumentException uce) {
                                if (!MockServerLogger.isEnabled(Level.DEBUG)) break block76;
                                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported MediaType with value \"" + entry.getValue() + "\"").setThrowable(uce));
                            }
                        }
                    }
                    if (key.equalsIgnoreCase("charset")) {
                        try {
                            charset = Charset.forName(String.valueOf(entry.getValue()));
                        }
                        catch (UnsupportedCharsetException uce) {
                            if (MockServerLogger.isEnabled(Level.DEBUG)) {
                                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported Charset with value \"" + entry.getValue() + "\"").setThrowable(uce));
                            }
                        }
                        catch (IllegalCharsetNameException icne) {
                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block77;
                            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring invalid Charset with value \"" + entry.getValue() + "\"").setThrowable(icne));
                        }
                    }
                }
                if (!key.equalsIgnoreCase("parameters")) continue;
                if (objectMapper == null) {
                    objectMapper = ObjectMapperFactory.createObjectMapper();
                }
                if (objectWriter == null) {
                    objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
                }
                parameters = (Parameters)objectMapper.readValue(objectWriter.writeValueAsString(entry.getValue()), Parameters.class);
            }
            if (type != null) {
                switch (1.$SwitchMap$org$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new BinaryBodyDTO(new BinaryBody(rawBytes, contentType), not);
                            break;
                        }
                        result = new BinaryBodyDTO(new BinaryBody(rawBytes), not);
                        break;
                    }
                    case 2: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, contentType, matchType), not);
                            break;
                        }
                        if (charset != null) {
                            result = new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_JSON_CONTENT_TYPE.withCharset(charset), matchType), not);
                            break;
                        }
                        result = new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_JSON_CONTENT_TYPE, matchType), not);
                        break;
                    }
                    case 3: {
                        result = new JsonSchemaBodyDTO(new JsonSchemaBody(valueJsonValue).withParameterStyles(parameterStyles), not);
                        break;
                    }
                    case 4: {
                        result = new JsonPathBodyDTO(new JsonPathBody(valueJsonValue), not);
                        break;
                    }
                    case 5: {
                        result = new ParameterBodyDTO(new ParameterBody(parameters), not);
                        break;
                    }
                    case 6: {
                        result = new RegexBodyDTO(new RegexBody(valueJsonValue), not);
                        break;
                    }
                    case 7: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, contentType), not);
                            break;
                        }
                        if (charset != null) {
                            result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, StringBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), not);
                            break;
                        }
                        result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, null), not);
                        break;
                    }
                    case 8: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, contentType), not);
                            break;
                        }
                        if (charset != null) {
                            result = new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_XML_CONTENT_TYPE.withCharset(charset)), not);
                            break;
                        }
                        result = new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_XML_CONTENT_TYPE), not);
                        break;
                    }
                    case 9: {
                        result = new XmlSchemaBodyDTO(new XmlSchemaBody(valueJsonValue), not);
                        break;
                    }
                    case 10: {
                        result = new XPathBodyDTO(new XPathBody(valueJsonValue, namespacePrefixes), not);
                    }
                }
            } else if (body.size() > 0) {
                if (jsonBodyObjectWriter == null) {
                    jsonBodyObjectWriter = ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues().writerWithDefaultPrettyPrinter();
                }
                result = new JsonBodyDTO(new JsonBody(jsonBodyObjectWriter.writeValueAsString((Object)body), JsonBody.DEFAULT_MATCH_TYPE), null);
            }
        } else if (currentToken == JsonToken.START_ARRAY) {
            if (jsonBodyObjectWriter == null) {
                jsonBodyObjectWriter = ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues().writerWithDefaultPrettyPrinter();
            }
            result = new JsonBodyDTO(new JsonBody(jsonBodyObjectWriter.writeValueAsString(ctxt.readValue(jsonParser, List.class)), JsonBody.DEFAULT_MATCH_TYPE), null);
        } else if (currentToken == JsonToken.VALUE_STRING) {
            result = new StringBodyDTO(new StringBody(jsonParser.getText()));
        }
        if (result == null && jsonParser.currentToken() == JsonToken.END_OBJECT) {
            result = new JsonBodyDTO(JsonBody.json("{ }"));
        }
        if (result != null) {
            result.withOptional(optional);
        }
        return result;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }

    static {
        fieldNameToType.put("base64Bytes".toLowerCase(), Body.Type.BINARY);
        fieldNameToType.put("json".toLowerCase(), Body.Type.JSON);
        fieldNameToType.put("jsonSchema".toLowerCase(), Body.Type.JSON_SCHEMA);
        fieldNameToType.put("jsonPath".toLowerCase(), Body.Type.JSON_PATH);
        fieldNameToType.put("parameters".toLowerCase(), Body.Type.PARAMETERS);
        fieldNameToType.put("regex".toLowerCase(), Body.Type.REGEX);
        fieldNameToType.put("string".toLowerCase(), Body.Type.STRING);
        fieldNameToType.put("xml".toLowerCase(), Body.Type.XML);
        fieldNameToType.put("xmlSchema".toLowerCase(), Body.Type.XML_SCHEMA);
        fieldNameToType.put("xpath".toLowerCase(), Body.Type.XPATH);
        MOCK_SERVER_LOGGER = new MockServerLogger(BodyDTODeserializer.class);
    }
}

