/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi.examples;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.mockserver.openapi.examples.models.ArrayExample;
import org.mockserver.openapi.examples.models.BigIntegerExample;
import org.mockserver.openapi.examples.models.BooleanExample;
import org.mockserver.openapi.examples.models.DecimalExample;
import org.mockserver.openapi.examples.models.DoubleExample;
import org.mockserver.openapi.examples.models.Example;
import org.mockserver.openapi.examples.models.FloatExample;
import org.mockserver.openapi.examples.models.IntegerExample;
import org.mockserver.openapi.examples.models.LongExample;
import org.mockserver.openapi.examples.models.ObjectExample;
import org.mockserver.openapi.examples.models.StringExample;

public class JsonExampleDeserializer
extends JsonDeserializer<Example> {
    public Example deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return this.createExample(node);
    }

    private Example createExample(JsonNode node) {
        if (node instanceof ObjectNode) {
            ObjectExample obj = new ObjectExample();
            ObjectNode on = (ObjectNode)node;
            Iterator x = on.fields();
            while (x.hasNext()) {
                Map.Entry i = (Map.Entry)x.next();
                String key = (String)i.getKey();
                JsonNode value = (JsonNode)i.getValue();
                obj.put(key, this.createExample(value));
            }
            return obj;
        }
        if (node instanceof ArrayNode) {
            ArrayExample arr = new ArrayExample();
            ArrayNode an = (ArrayNode)node;
            for (JsonNode childNode : an) {
                arr.add(this.createExample(childNode));
            }
            return arr;
        }
        if (node instanceof DoubleNode) {
            return new DoubleExample(node.doubleValue());
        }
        if (node instanceof IntNode || node instanceof ShortNode) {
            return new IntegerExample(node.intValue());
        }
        if (node instanceof FloatNode) {
            return new FloatExample(node.floatValue());
        }
        if (node instanceof BigIntegerNode) {
            return new BigIntegerExample(node.bigIntegerValue());
        }
        if (node instanceof DecimalNode) {
            return new DecimalExample(node.decimalValue());
        }
        if (node instanceof LongNode) {
            return new LongExample(node.longValue());
        }
        if (node instanceof BooleanNode) {
            return new BooleanExample(node.booleanValue());
        }
        return new StringExample(node.asText());
    }
}

