/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.event.Level;

public class HttpResponseClassCallbackActionHandler {
    private static ClassLoader contextClassLoader = ClassLoader.getSystemClassLoader();
    private final MockServerLogger mockServerLogger;

    public static void setContextClassLoader(ClassLoader contextClassLoader) {
        HttpResponseClassCallbackActionHandler.contextClassLoader = contextClassLoader;
    }

    public HttpResponseClassCallbackActionHandler(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public HttpResponse handle(HttpClassCallback httpClassCallback, HttpRequest request) {
        return this.invokeCallbackMethod(httpClassCallback, request);
    }

    private ExpectationResponseCallback instantiateCallback(HttpClassCallback httpClassCallback) {
        try {
            Class<?> expectationResponseCallbackClass = contextClassLoader.loadClass(httpClassCallback.getCallbackClass());
            if (ExpectationResponseCallback.class.isAssignableFrom(expectationResponseCallbackClass)) {
                Constructor<?> constructor = expectationResponseCallbackClass.getConstructor(new Class[0]);
                return (ExpectationResponseCallback)constructor.newInstance(new Object[0]);
            }
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(null).setMessageFormat(httpClassCallback.getCallbackClass() + " does not implement " + ExpectationResponseCallback.class.getName() + " required for responses using class callback"));
        }
        catch (ClassNotFoundException e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("ClassNotFoundException - while trying to instantiate ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"").setThrowable(e));
        }
        catch (NoSuchMethodException e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("NoSuchMethodException - while trying to create default constructor on ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"").setThrowable(e));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("InvocationTargetException - while trying to execute default constructor on ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"").setThrowable(e));
        }
        return null;
    }

    private HttpResponse invokeCallbackMethod(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationResponseCallback expectationResponseCallback = this.instantiateCallback(httpClassCallback);
            if (expectationResponseCallback != null) {
                try {
                    return expectationResponseCallback.handle(httpRequest);
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(httpRequest).setMessageFormat(httpClassCallback.getCallbackClass() + " throw exception while executing handle callback method - " + throwable.getMessage()).setThrowable(throwable));
                    return HttpResponse.notFoundResponse();
                }
            }
            return HttpResponse.notFoundResponse();
        }
        return HttpResponse.notFoundResponse();
    }
}

