/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lmax.disruptor.EventTranslator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.LogEntryBody;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.time.EpochService;
import org.mockserver.uuid.UUIDService;
import org.slf4j.event.Level;

public class LogEntry
implements EventTranslator<LogEntry> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private static final RequestDefinition[] EMPTY_REQUEST_DEFINITIONS = new RequestDefinition[0];
    private static final RequestDefinition[] DEFAULT_REQUESTS_DEFINITIONS = new RequestDefinition[]{HttpRequest.request()};
    public static final DateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private int hashCode;
    private String id;
    private String correlationId;
    private Integer port;
    private Level logLevel = Level.INFO;
    private boolean alwaysLog = false;
    private long epochTime = EpochService.currentTimeMillis();
    private String timestamp;
    private LogMessageType type;
    private RequestDefinition[] httpRequests;
    private RequestDefinition[] httpUpdatedRequests;
    private HttpResponse httpResponse;
    private HttpResponse httpUpdatedResponse;
    private HttpError httpError;
    private Expectation expectation;
    private String expectationId;
    private Throwable throwable;
    private Runnable consumer;
    private boolean deleted = false;
    private String messageFormat;
    private String message;
    private Object[] arguments;
    private String because;

    private LogEntry setId(String id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    public String id() {
        if (this.id == null) {
            this.id = UUIDService.getUUID();
        }
        return this.id;
    }

    public void clear() {
        this.id = null;
        this.logLevel = Level.INFO;
        this.alwaysLog = false;
        this.correlationId = null;
        this.port = null;
        this.epochTime = -1L;
        this.timestamp = null;
        this.type = null;
        this.httpRequests = null;
        this.httpResponse = null;
        this.httpError = null;
        this.expectation = null;
        this.expectationId = null;
        this.throwable = null;
        this.consumer = null;
        this.deleted = false;
        this.messageFormat = null;
        this.message = null;
        this.arguments = null;
        this.because = null;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public LogEntry setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        if (this.type == null) {
            this.type = LogMessageType.valueOf(logLevel.name());
        }
        return this;
    }

    public boolean isAlwaysLog() {
        return this.alwaysLog;
    }

    public LogEntry setAlwaysLog(boolean alwaysLog) {
        this.alwaysLog = alwaysLog;
        return this;
    }

    public long getEpochTime() {
        return this.epochTime;
    }

    public LogEntry setEpochTime(long epochTime) {
        this.epochTime = epochTime;
        this.timestamp = null;
        return this;
    }

    public String getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = LOG_DATE_FORMAT.format(new Date(this.epochTime));
        }
        return this.timestamp;
    }

    public LogMessageType getType() {
        return this.type;
    }

    public LogEntry setType(LogMessageType type) {
        this.type = type;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public LogEntry setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public LogEntry setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    @JsonIgnore
    public RequestDefinition[] getHttpRequests() {
        if (this.httpRequests == null) {
            return EMPTY_REQUEST_DEFINITIONS;
        }
        return this.httpRequests;
    }

    @JsonIgnore
    public RequestDefinition[] getHttpUpdatedRequests() {
        if (this.httpRequests == null) {
            return EMPTY_REQUEST_DEFINITIONS;
        }
        if (this.httpUpdatedRequests == null) {
            this.httpUpdatedRequests = (RequestDefinition[])Arrays.stream(this.httpRequests).map(this::updateBody).toArray(RequestDefinition[]::new);
            return this.httpUpdatedRequests;
        }
        return this.httpUpdatedRequests;
    }

    @JsonIgnore
    public boolean matches(HttpRequestMatcher matcher) {
        if (matcher == null) {
            return true;
        }
        if (this.httpRequests == null || this.httpRequests.length == 0) {
            return true;
        }
        RequestDefinition[] requestDefinitionArray = this.httpRequests;
        int n = requestDefinitionArray.length;
        for (int i = 0; i < n; ++i) {
            RequestDefinition httpRequest;
            RequestDefinition request;
            if (!matcher.matches(this.type == LogMessageType.RECEIVED_REQUEST ? new MatchDifference(false, request) : null, request = (httpRequest = requestDefinitionArray[i]).cloneWithLogCorrelationId())) continue;
            return true;
        }
        return false;
    }

    public LogEntry setHttpRequests(RequestDefinition[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public RequestDefinition getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public LogEntry setHttpRequest(RequestDefinition httpRequest) {
        if (httpRequest != null) {
            if (StringUtils.isNotBlank((CharSequence)httpRequest.getLogCorrelationId())) {
                this.setCorrelationId(httpRequest.getLogCorrelationId());
            }
            this.httpRequests = new RequestDefinition[]{httpRequest};
        } else {
            this.httpRequests = DEFAULT_REQUESTS_DEFINITIONS;
        }
        return this;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public HttpResponse getHttpUpdatedResponse() {
        if (this.httpResponse == null) {
            return null;
        }
        if (this.httpUpdatedResponse == null) {
            this.httpUpdatedResponse = this.updateBody(this.httpResponse);
            return this.httpUpdatedResponse;
        }
        return this.httpUpdatedResponse;
    }

    public LogEntry setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public LogEntry setHttpError(HttpError httpError) {
        this.httpError = httpError;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public LogEntry setExpectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    public LogEntry setExpectation(RequestDefinition httpRequest, HttpResponse httpResponse) {
        this.expectation = new Expectation(httpRequest, Times.once(), TimeToLive.unlimited(), 0).thenRespond(httpResponse);
        return this;
    }

    public String getExpectationId() {
        return this.expectationId;
    }

    public LogEntry setExpectationId(String expectationId) {
        this.expectationId = expectationId;
        return this;
    }

    public boolean matchesAnyExpectationId(List<String> expectationIds) {
        if (expectationIds != null && StringUtils.isNotBlank((CharSequence)this.expectationId)) {
            return expectationIds.contains(this.expectationId);
        }
        return false;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public LogEntry setThrowable(Throwable throwable) {
        this.throwable = throwable;
        if (StringUtils.isBlank((CharSequence)this.messageFormat) && throwable != null) {
            this.messageFormat = throwable.getClass().getSimpleName();
        }
        return this;
    }

    public Runnable getConsumer() {
        return this.consumer;
    }

    public LogEntry setConsumer(Runnable consumer) {
        this.consumer = consumer;
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public LogEntry setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public LogEntry setMessageFormat(String messageFormat) {
        this.messageFormat = StringUtils.isBlank((CharSequence)messageFormat) && this.throwable != null ? this.throwable.getClass().getSimpleName() : messageFormat;
        return this;
    }

    @JsonIgnore
    public String getMessage() {
        if (this.message == null) {
            this.message = this.arguments != null ? StringFormatter.formatLogMessage(this.messageFormat, this.arguments) : this.messageFormat;
        }
        return this.message;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public LogEntry setArguments(Object ... arguments) {
        this.arguments = arguments != null ? Arrays.stream(arguments).map(argument -> {
            if (argument instanceof HttpRequest) {
                return this.updateBody((HttpRequest)argument);
            }
            if (argument instanceof HttpResponse) {
                return this.updateBody((HttpResponse)argument);
            }
            if (argument == null) {
                return "";
            }
            return argument;
        }).toArray(Object[]::new) : null;
        return this;
    }

    public String getBecause() {
        return this.because;
    }

    public LogEntry setBecause(String because) {
        this.because = because;
        return this;
    }

    private RequestDefinition updateBody(RequestDefinition requestDefinition) {
        if (requestDefinition instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)requestDefinition;
            Body body = httpRequest.getBody();
            if (body instanceof JsonBody) {
                try {
                    return httpRequest.shallowClone().withBody(new LogEntryBody(OBJECT_MAPPER.readTree(body.toString())));
                }
                catch (Throwable throwable) {
                    return httpRequest.shallowClone().withBody(new LogEntryBody(body.toString()));
                }
            }
            if (body instanceof ParameterBody) {
                return httpRequest.shallowClone().withBody(new LogEntryBody(body.toString()));
            }
            if (body instanceof BodyWithContentType && !(body instanceof LogEntryBody)) {
                return httpRequest.shallowClone().withBody(new LogEntryBody(body.toString()));
            }
            return httpRequest;
        }
        return null;
    }

    private HttpResponse updateBody(HttpResponse httpResponse) {
        if (httpResponse != null) {
            BodyWithContentType body = httpResponse.getBody();
            if (body != null && JsonBody.class.isAssignableFrom(body.getClass())) {
                try {
                    return httpResponse.shallowClone().withBody(new LogEntryBody(OBJECT_MAPPER.readTree(body.toString())));
                }
                catch (Throwable throwable) {
                    return httpResponse.shallowClone().withBody(new LogEntryBody(body.toString()));
                }
            }
            if (body != null && !(body instanceof LogEntryBody)) {
                return httpResponse.shallowClone().withBody(new LogEntryBody(body.toString()));
            }
            return httpResponse;
        }
        return null;
    }

    public LogEntry cloneAndClear() {
        LogEntry clone = this.clone();
        this.clear();
        return clone;
    }

    public LogEntry clone() {
        return new LogEntry().setId(this.id()).setType(this.getType()).setLogLevel(this.getLogLevel()).setAlwaysLog(this.isAlwaysLog()).setEpochTime(this.getEpochTime()).setCorrelationId(this.getCorrelationId()).setPort(this.getPort()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setExpectationId(this.getExpectationId()).setMessageFormat(this.getMessageFormat()).setArguments(this.getArguments()).setBecause(this.getBecause()).setThrowable(this.getThrowable()).setConsumer(this.getConsumer()).setDeleted(this.isDeleted());
    }

    public void translateTo(LogEntry event, long sequence) {
        event.setId(this.id()).setType(this.getType()).setLogLevel(this.getLogLevel()).setAlwaysLog(this.isAlwaysLog()).setEpochTime(this.getEpochTime()).setCorrelationId(this.getCorrelationId()).setPort(this.getPort()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setExpectationId(this.getExpectationId()).setMessageFormat(this.getMessageFormat()).setArguments(this.getArguments()).setBecause(this.getBecause()).setThrowable(this.getThrowable()).setConsumer(this.getConsumer()).setDeleted(this.isDeleted());
        this.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        LogEntry logEntry = (LogEntry)o;
        return this.epochTime == logEntry.epochTime && this.deleted == logEntry.deleted && this.type == logEntry.type && this.logLevel == logEntry.logLevel && this.alwaysLog == logEntry.alwaysLog && Objects.equals(this.messageFormat, logEntry.messageFormat) && Objects.equals(this.httpResponse, logEntry.httpResponse) && Objects.equals(this.httpError, logEntry.httpError) && Objects.equals(this.expectation, logEntry.expectation) && Objects.equals(this.expectationId, logEntry.expectationId) && Objects.equals(this.consumer, logEntry.consumer) && Arrays.equals(this.arguments, logEntry.arguments) && Arrays.equals(this.httpRequests, logEntry.httpRequests);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(new Object[]{this.epochTime, this.deleted, this.type, this.logLevel, this.alwaysLog, this.messageFormat, this.httpResponse, this.httpError, this.expectation, this.expectationId, this.consumer});
            result = 31 * result + Arrays.hashCode(this.arguments);
            this.hashCode = result = 31 * result + Arrays.hashCode(this.httpRequests);
        }
        return this.hashCode;
    }

    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]).writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static enum LogMessageType {
        RUNNABLE,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        EXCEPTION,
        CLEARED,
        RETRIEVED,
        UPDATED_EXPECTATION,
        CREATED_EXPECTATION,
        REMOVED_EXPECTATION,
        RECEIVED_REQUEST,
        EXPECTATION_RESPONSE,
        EXPECTATION_MATCHED,
        EXPECTATION_NOT_MATCHED,
        NO_MATCH_RESPONSE,
        VERIFICATION,
        VERIFICATION_FAILED,
        VERIFICATION_PASSED,
        FORWARDED_REQUEST,
        TEMPLATE_GENERATED,
        SERVER_CONFIGURATION,
        AUTHENTICATION_FAILED;

    }
}

