/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.configuration;

import org.mockserver.configuration.Configuration;
import org.mockserver.configuration.ConfigurationProperties;

public class ClientConfiguration {
    private Configuration serverConfiguration;
    private Integer maxWebSocketExpectations;
    private Integer webSocketClientEventLoopThreadCount;
    private Integer clientNioEventLoopThreadCount;
    private Long maxSocketTimeoutInMillis;
    private Long maxFutureTimeoutInMillis;
    private Boolean controlPlaneTLSMutualAuthenticationRequired;
    private String controlPlaneTLSMutualAuthenticationCAChain;
    private String controlPlanePrivateKeyPath;
    private String controlPlaneX509CertificatePath;
    private Boolean controlPlaneJWTAuthenticationRequired;
    private String controlPlaneJWTAuthenticationJWKSource;

    public static ClientConfiguration clientConfiguration() {
        return new ClientConfiguration();
    }

    public static ClientConfiguration clientConfiguration(Configuration configuration) {
        return new ClientConfiguration(configuration);
    }

    public ClientConfiguration() {
    }

    public ClientConfiguration(Configuration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
        if (serverConfiguration == null) {
            serverConfiguration = Configuration.configuration();
        }
        this.webSocketClientEventLoopThreadCount(serverConfiguration.webSocketClientEventLoopThreadCount());
        this.clientNioEventLoopThreadCount(serverConfiguration.clientNioEventLoopThreadCount());
        this.maxSocketTimeoutInMillis(serverConfiguration.maxSocketTimeoutInMillis());
        this.maxFutureTimeoutInMillis(serverConfiguration.maxFutureTimeoutInMillis());
        this.controlPlaneTLSMutualAuthenticationRequired(serverConfiguration.controlPlaneTLSMutualAuthenticationRequired());
        this.controlPlaneTLSMutualAuthenticationCAChain(serverConfiguration.controlPlaneTLSMutualAuthenticationCAChain());
        this.controlPlanePrivateKeyPath(serverConfiguration.controlPlanePrivateKeyPath());
        this.controlPlaneX509CertificatePath(serverConfiguration.controlPlaneX509CertificatePath());
        this.controlPlaneJWTAuthenticationRequired(serverConfiguration.controlPlaneJWTAuthenticationRequired());
        this.controlPlaneJWTAuthenticationJWKSource(serverConfiguration.controlPlaneJWTAuthenticationJWKSource());
    }

    public Configuration toServerConfiguration() {
        if (this.serverConfiguration == null) {
            this.serverConfiguration = Configuration.configuration();
        }
        this.serverConfiguration.webSocketClientEventLoopThreadCount(this.webSocketClientEventLoopThreadCount);
        this.serverConfiguration.clientNioEventLoopThreadCount(this.clientNioEventLoopThreadCount);
        this.serverConfiguration.maxSocketTimeoutInMillis(this.maxSocketTimeoutInMillis);
        this.serverConfiguration.maxFutureTimeoutInMillis(this.maxFutureTimeoutInMillis);
        this.serverConfiguration.controlPlaneTLSMutualAuthenticationRequired(this.controlPlaneTLSMutualAuthenticationRequired);
        this.serverConfiguration.controlPlaneTLSMutualAuthenticationCAChain(this.controlPlaneTLSMutualAuthenticationCAChain);
        this.serverConfiguration.controlPlanePrivateKeyPath(this.controlPlanePrivateKeyPath);
        this.serverConfiguration.controlPlaneX509CertificatePath(this.controlPlaneX509CertificatePath);
        this.serverConfiguration.controlPlaneJWTAuthenticationRequired(this.controlPlaneJWTAuthenticationRequired);
        this.serverConfiguration.controlPlaneJWTAuthenticationJWKSource(this.controlPlaneJWTAuthenticationJWKSource);
        return this.serverConfiguration;
    }

    public Integer maxWebSocketExpectations() {
        if (this.maxWebSocketExpectations == null) {
            this.maxWebSocketExpectations = ConfigurationProperties.maxWebSocketExpectations();
        }
        return this.maxWebSocketExpectations;
    }

    public ClientConfiguration maxWebSocketExpectations(Integer maxWebSocketExpectations) {
        this.maxWebSocketExpectations = maxWebSocketExpectations;
        return this;
    }

    public Integer webSocketClientEventLoopThreadCount() {
        if (this.webSocketClientEventLoopThreadCount == null) {
            this.webSocketClientEventLoopThreadCount = ConfigurationProperties.webSocketClientEventLoopThreadCount();
        }
        return this.webSocketClientEventLoopThreadCount;
    }

    public ClientConfiguration webSocketClientEventLoopThreadCount(Integer webSocketClientEventLoopThreadCount) {
        this.webSocketClientEventLoopThreadCount = webSocketClientEventLoopThreadCount;
        return this;
    }

    public Integer clientNioEventLoopThreadCount() {
        if (this.clientNioEventLoopThreadCount == null) {
            this.clientNioEventLoopThreadCount = ConfigurationProperties.clientNioEventLoopThreadCount();
        }
        return this.clientNioEventLoopThreadCount;
    }

    public ClientConfiguration clientNioEventLoopThreadCount(Integer clientNioEventLoopThreadCount) {
        this.clientNioEventLoopThreadCount = clientNioEventLoopThreadCount;
        return this;
    }

    public Long maxSocketTimeoutInMillis() {
        if (this.maxSocketTimeoutInMillis == null) {
            this.maxSocketTimeoutInMillis = ConfigurationProperties.maxSocketTimeout();
        }
        return this.maxSocketTimeoutInMillis;
    }

    public ClientConfiguration maxSocketTimeoutInMillis(Long maxSocketTimeoutInMillis) {
        this.maxSocketTimeoutInMillis = maxSocketTimeoutInMillis;
        return this;
    }

    public Long maxFutureTimeoutInMillis() {
        if (this.maxFutureTimeoutInMillis == null) {
            this.maxFutureTimeoutInMillis = ConfigurationProperties.maxFutureTimeout();
        }
        return this.maxFutureTimeoutInMillis;
    }

    public ClientConfiguration maxFutureTimeoutInMillis(Long maxFutureTimeoutInMillis) {
        this.maxFutureTimeoutInMillis = maxFutureTimeoutInMillis;
        return this;
    }

    public Boolean controlPlaneTLSMutualAuthenticationRequired() {
        if (this.controlPlaneTLSMutualAuthenticationRequired == null) {
            this.controlPlaneTLSMutualAuthenticationRequired = ConfigurationProperties.controlPlaneTLSMutualAuthenticationRequired();
        }
        return this.controlPlaneTLSMutualAuthenticationRequired;
    }

    public ClientConfiguration controlPlaneTLSMutualAuthenticationRequired(Boolean controlPlaneTLSMutualAuthenticationRequired) {
        this.controlPlaneTLSMutualAuthenticationRequired = controlPlaneTLSMutualAuthenticationRequired;
        return this;
    }

    public String controlPlaneTLSMutualAuthenticationCAChain() {
        if (this.controlPlaneTLSMutualAuthenticationCAChain == null) {
            this.controlPlaneTLSMutualAuthenticationCAChain = ConfigurationProperties.controlPlaneTLSMutualAuthenticationCAChain();
        }
        return this.controlPlaneTLSMutualAuthenticationCAChain;
    }

    public ClientConfiguration controlPlaneTLSMutualAuthenticationCAChain(String controlPlaneTLSMutualAuthenticationCAChain) {
        this.controlPlaneTLSMutualAuthenticationCAChain = controlPlaneTLSMutualAuthenticationCAChain;
        return this;
    }

    public String controlPlanePrivateKeyPath() {
        if (this.controlPlanePrivateKeyPath == null) {
            this.controlPlanePrivateKeyPath = ConfigurationProperties.controlPlanePrivateKeyPath();
        }
        return this.controlPlanePrivateKeyPath;
    }

    public ClientConfiguration controlPlanePrivateKeyPath(String controlPlanePrivateKeyPath) {
        this.controlPlanePrivateKeyPath = controlPlanePrivateKeyPath;
        return this;
    }

    public String controlPlaneX509CertificatePath() {
        if (this.controlPlaneX509CertificatePath == null) {
            this.controlPlaneX509CertificatePath = ConfigurationProperties.controlPlaneX509CertificatePath();
        }
        return this.controlPlaneX509CertificatePath;
    }

    public ClientConfiguration controlPlaneX509CertificatePath(String controlPlaneX509CertificatePath) {
        this.controlPlaneX509CertificatePath = controlPlaneX509CertificatePath;
        return this;
    }

    public Boolean controlPlaneJWTAuthenticationRequired() {
        if (this.controlPlaneJWTAuthenticationRequired == null) {
            this.controlPlaneJWTAuthenticationRequired = ConfigurationProperties.controlPlaneJWTAuthenticationRequired();
        }
        return this.controlPlaneJWTAuthenticationRequired;
    }

    public ClientConfiguration controlPlaneJWTAuthenticationRequired(Boolean controlPlaneJWTAuthenticationRequired) {
        this.controlPlaneJWTAuthenticationRequired = controlPlaneJWTAuthenticationRequired;
        return this;
    }

    public String controlPlaneJWTAuthenticationJWKSource() {
        if (this.controlPlaneJWTAuthenticationJWKSource == null) {
            this.controlPlaneJWTAuthenticationJWKSource = ConfigurationProperties.controlPlaneJWTAuthenticationJWKSource();
        }
        return this.controlPlaneJWTAuthenticationJWKSource;
    }

    public ClientConfiguration controlPlaneJWTAuthenticationJWKSource(String controlPlaneJWTAuthenticationJWKSource) {
        this.controlPlaneJWTAuthenticationJWKSource = controlPlaneJWTAuthenticationJWKSource;
        return this;
    }
}

