/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.exceptions.TooManyMethodsFoundException;

public class MethodProxy {
    public static void proxy(Method method, InvocationHandler invocationHandler) {
        MethodProxy.assertInvocationHandlerNotNull(invocationHandler);
        MockRepository.putMethodProxy((Method)method, (InvocationHandler)invocationHandler);
    }

    public static void proxy(Class<?> declaringClass, String methodName, InvocationHandler invocationHandler) {
        MethodProxy.assertInvocationHandlerNotNull(invocationHandler);
        if (declaringClass == null) {
            throw new IllegalArgumentException("declaringClass cannot be null");
        }
        if (methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be empty");
        }
        Method[] methods = Whitebox.getMethods(declaringClass, (String[])new String[]{methodName});
        if (methods.length == 0) {
            throw new MethodNotFoundException(String.format("Couldn't find a method with name %s in the class hierarchy of %s", methodName, declaringClass.getName()));
        }
        if (methods.length > 1) {
            throw new TooManyMethodsFoundException(String.format("Found %d methods with name %s in the class hierarchy of %s.", methods.length, methodName, declaringClass.getName()));
        }
        MockRepository.putMethodProxy((Method)methods[0], (InvocationHandler)invocationHandler);
    }

    private static void assertInvocationHandlerNotNull(InvocationHandler invocationHandler) {
        if (invocationHandler == null) {
            throw new IllegalArgumentException("invocationHandler cannot be null");
        }
    }
}

