/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.mail.Flags;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

class FetchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "FETCH";
    public static final String ARGS = "<message-set> <fetch-profile>";
    private FetchCommandParser parser = new FetchCommandParser();

    FetchCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        IdRange[] idSet = this.parser.parseIdRange(request);
        FetchRequest fetch = this.parser.fetchRequest(request);
        this.parser.endLine(request);
        if (useUids) {
            fetch.uid = true;
        }
        ImapSessionFolder mailbox = session.getSelected();
        long[] uids = mailbox.getMessageUids();
        for (int i = 0; i < uids.length; ++i) {
            long uid = uids[i];
            int msn = mailbox.getMsn(uid);
            if ((!useUids || !this.includes(idSet, uid)) && (useUids || !this.includes(idSet, msn))) continue;
            SimpleStoredMessage storedMessage = mailbox.getMessage(uid);
            String msgData = this.outputMessage(fetch, storedMessage, mailbox, useUids);
            response.fetchResponse(msn, msgData);
        }
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }

    private String outputMessage(FetchRequest fetch, SimpleStoredMessage message, ImapSessionFolder folder, boolean useUids) throws FolderException, ProtocolException {
        boolean ensureFlagsResponse = false;
        if (fetch.isSetSeen() && !message.getFlags().contains(Flags.Flag.SEEN)) {
            folder.setFlags(new Flags(Flags.Flag.SEEN), true, message.getUid(), folder, useUids);
            message.getFlags().add(Flags.Flag.SEEN);
            ensureFlagsResponse = true;
        }
        StringBuffer response = new StringBuffer();
        if (fetch.flags || ensureFlagsResponse) {
            response.append(" FLAGS ");
            response.append(MessageFlags.format(message.getFlags()));
        }
        if (fetch.internalDate) {
            response.append(" INTERNALDATE \"");
            response.append(message.getAttributes().getInternalDateAsString());
            response.append("\"");
        }
        if (fetch.size) {
            response.append(" RFC822.SIZE ");
            response.append(message.getAttributes().getSize());
        }
        if (fetch.envelope) {
            response.append(" ENVELOPE ");
            response.append(message.getAttributes().getEnvelope());
        }
        if (fetch.body) {
            response.append(" BODY ");
            response.append(message.getAttributes().getBodyStructure(false));
        }
        if (fetch.bodyStructure) {
            response.append(" BODYSTRUCTURE ");
            response.append(message.getAttributes().getBodyStructure(true));
        }
        if (fetch.uid) {
            response.append(" UID ");
            response.append(message.getUid());
        }
        Collection elements = fetch.getBodyElements();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            BodyFetchElement fetchElement = (BodyFetchElement)iterator.next();
            response.append(" ");
            response.append(fetchElement.getResponseName());
            if (null == fetchElement.getPartial()) {
                response.append(" ");
            }
            String sectionSpecifier = fetchElement.getParameters();
            MimeMessage mimeMessage = message.getMimeMessage();
            try {
                this.handleBodyFetch(mimeMessage, sectionSpecifier, fetchElement.getPartial(), response);
            }
            catch (Exception e) {
                throw new FolderException(e.getMessage());
            }
        }
        if (response.length() > 0) {
            return response.substring(1);
        }
        return "";
    }

    private void handleBodyFetch(MimeMessage mimeMessage, String sectionSpecifier, String partial, StringBuffer response) throws Exception {
        if (sectionSpecifier.length() == 0) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)bout);
            byte[] bytes = bout.toByteArray();
            bytes = this.doPartial(partial, bytes, response);
            this.addLiteral(bytes, response);
        } else if (sectionSpecifier.equalsIgnoreCase("HEADER")) {
            Enumeration inum = mimeMessage.getAllHeaderLines();
            this.addHeaders(inum, response);
        } else if (sectionSpecifier.startsWith("HEADER.FIELDS.NOT")) {
            String[] excludeNames = this.extractHeaderList(sectionSpecifier, "HEADER.FIELDS.NOT".length());
            Enumeration inum = mimeMessage.getNonMatchingHeaderLines(excludeNames);
            this.addHeaders(inum, response);
        } else if (sectionSpecifier.startsWith("HEADER.FIELDS ")) {
            String[] includeNames = this.extractHeaderList(sectionSpecifier, "HEADER.FIELDS ".length());
            Enumeration inum = mimeMessage.getMatchingHeaderLines(includeNames);
            this.addHeaders(inum, response);
        } else if (sectionSpecifier.endsWith("MIME")) {
            String[] strs = sectionSpecifier.trim().split("\\.");
            int partNumber = Integer.parseInt(strs[0]) - 1;
            MimeMultipart mp = (MimeMultipart)mimeMessage.getContent();
            byte[] bytes = GreenMailUtil.getHeaderAsBytes((Part)mp.getBodyPart(partNumber));
            bytes = this.doPartial(partial, bytes, response);
            this.addLiteral(bytes, response);
        } else if (sectionSpecifier.equalsIgnoreCase("TEXT")) {
            byte[] bytes = GreenMailUtil.getBodyAsBytes((Part)mimeMessage);
            bytes = this.doPartial(partial, bytes, response);
            this.addLiteral(bytes, response);
        } else {
            int partNumber = Integer.parseInt(sectionSpecifier) - 1;
            MimeMultipart mp = (MimeMultipart)mimeMessage.getContent();
            byte[] bytes = GreenMailUtil.getBodyAsBytes((Part)mp.getBodyPart(partNumber));
            bytes = this.doPartial(partial, bytes, response);
            this.addLiteral(bytes, response);
        }
    }

    private byte[] doPartial(String partial, byte[] bytes, StringBuffer response) {
        if (null != partial) {
            String[] strs = partial.split("\\.");
            int start = Integer.parseInt(strs[0]);
            int len = 2 == strs.length ? Integer.parseInt(strs[1]) : bytes.length;
            start = Math.min(start, bytes.length);
            len = Math.min(len, bytes.length);
            byte[] newBytes = new byte[len];
            System.arraycopy(bytes, start, newBytes, 0, len);
            bytes = newBytes;
            response.append("<");
            response.append(start);
            response.append("> ");
        }
        return bytes;
    }

    private void addLiteral(byte[] bytes, StringBuffer response) {
        response.append('{');
        response.append(bytes.length);
        response.append('}');
        response.append("\r\n");
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            response.append((char)b);
        }
    }

    private String[] extractHeaderList(String headerList, int prefixLen) {
        String tmp = headerList.substring(prefixLen + 1, headerList.length() - 1);
        String[] headerNames = this.split(tmp, " ");
        return headerNames;
    }

    private String[] split(String value, String delimiter) {
        String sub;
        int delimPos;
        ArrayList<String> strings = new ArrayList<String>();
        int startPos = 0;
        while ((delimPos = value.indexOf(delimiter, startPos)) != -1) {
            sub = value.substring(startPos, delimPos);
            strings.add(sub);
            startPos = delimPos + 1;
        }
        sub = value.substring(startPos);
        strings.add(sub);
        return strings.toArray(new String[0]);
    }

    private void addHeaders(Enumeration inum, StringBuffer response) {
        ArrayList<String> lines = new ArrayList<String>();
        int count = 0;
        while (inum.hasMoreElements()) {
            String line = (String)inum.nextElement();
            count += line.length() + 2;
            lines.add(line);
        }
        response.append('{');
        response.append(count + 2);
        response.append('}');
        response.append("\r\n");
        Iterator lit = lines.iterator();
        while (lit.hasNext()) {
            String line = (String)lit.next();
            response.append(line);
            response.append("\r\n");
        }
        response.append("\r\n");
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class BodyFetchElement {
        private String name;
        private String sectionIdentifier;
        private String partial;

        public BodyFetchElement(String name, String sectionIdentifier) {
            this(name, sectionIdentifier, null);
        }

        public BodyFetchElement(String name, String sectionIdentifier, String partial) {
            this.name = name;
            this.sectionIdentifier = sectionIdentifier;
            this.partial = partial;
        }

        public String getParameters() {
            return this.sectionIdentifier;
        }

        public String getResponseName() {
            return this.name;
        }

        public String getPartial() {
            return this.partial;
        }
    }

    private static class FetchRequest {
        boolean flags;
        boolean uid;
        boolean internalDate;
        boolean size;
        boolean envelope;
        boolean body;
        boolean bodyStructure;
        private boolean setSeen = false;
        private Set bodyElements = new HashSet();

        private FetchRequest() {
        }

        public Collection getBodyElements() {
            return this.bodyElements;
        }

        public boolean isSetSeen() {
            return this.setSeen;
        }

        public void add(BodyFetchElement element, boolean peek) {
            if (!peek) {
                this.setSeen = true;
            }
            this.bodyElements.add(element);
        }
    }

    private class FetchCommandParser
    extends CommandParser {
        private FetchCommandParser() {
        }

        public FetchRequest fetchRequest(ImapRequestLineReader request) throws ProtocolException {
            FetchRequest fetch = new FetchRequest();
            char next = this.nextNonSpaceChar(request);
            this.consumeChar(request, '(');
            next = this.nextNonSpaceChar(request);
            while (next != ')') {
                this.addNextElement(request, fetch);
                next = this.nextNonSpaceChar(request);
            }
            this.consumeChar(request, ')');
            return fetch;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addNextElement(ImapRequestLineReader command, FetchRequest fetch) throws ProtocolException {
            char next = this.nextCharInLine(command);
            StringBuffer element = new StringBuffer();
            while (next != ' ' && next != '[' && next != ')') {
                element.append(next);
                command.consume();
                next = this.nextCharInLine(command);
            }
            String name = element.toString();
            if (next == ' ' || next == ')') {
                if ("FAST".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    fetch.internalDate = true;
                    fetch.size = true;
                    return;
                } else if ("FULL".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    fetch.internalDate = true;
                    fetch.size = true;
                    fetch.envelope = true;
                    fetch.body = true;
                    return;
                } else if ("ALL".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    fetch.internalDate = true;
                    fetch.size = true;
                    fetch.envelope = true;
                    return;
                } else if ("FLAGS".equalsIgnoreCase(name)) {
                    fetch.flags = true;
                    return;
                } else if ("RFC822.SIZE".equalsIgnoreCase(name)) {
                    fetch.size = true;
                    return;
                } else if ("ENVELOPE".equalsIgnoreCase(name)) {
                    fetch.envelope = true;
                    return;
                } else if ("INTERNALDATE".equalsIgnoreCase(name)) {
                    fetch.internalDate = true;
                    return;
                } else if ("BODY".equalsIgnoreCase(name)) {
                    fetch.body = true;
                    return;
                } else if ("BODYSTRUCTURE".equalsIgnoreCase(name)) {
                    fetch.bodyStructure = true;
                    return;
                } else if ("UID".equalsIgnoreCase(name)) {
                    fetch.uid = true;
                    return;
                } else if ("RFC822".equalsIgnoreCase(name)) {
                    fetch.add(new BodyFetchElement("RFC822", ""), false);
                    return;
                } else if ("RFC822.HEADER".equalsIgnoreCase(name)) {
                    fetch.add(new BodyFetchElement("RFC822.HEADER", "HEADER"), true);
                    return;
                } else {
                    if (!"RFC822.TEXT".equalsIgnoreCase(name)) throw new ProtocolException("Invalid fetch attribute: " + name);
                    fetch.add(new BodyFetchElement("RFC822.TEXT", "TEXT"), false);
                }
                return;
            } else {
                this.consumeChar(command, '[');
                StringBuffer sectionIdentifier = new StringBuffer();
                next = this.nextCharInLine(command);
                while (next != ']') {
                    sectionIdentifier.append(next);
                    command.consume();
                    next = this.nextCharInLine(command);
                }
                this.consumeChar(command, ']');
                String parameter = sectionIdentifier.toString();
                String partial = null;
                next = this.nextCharInLine(command);
                if ('<' == next) {
                    partial = "";
                    this.consumeChar(command, '<');
                    next = this.nextCharInLine(command);
                    while (next != '>') {
                        partial = partial + next;
                        command.consume();
                        next = this.nextCharInLine(command);
                    }
                    this.consumeChar(command, '>');
                    next = this.nextCharInLine(command);
                }
                if ("BODY".equalsIgnoreCase(name)) {
                    fetch.add(new BodyFetchElement("BODY[" + parameter + "]", parameter, partial), false);
                    return;
                } else {
                    if (!"BODY.PEEK".equalsIgnoreCase(name)) throw new ProtocolException("Invalid fetch attibute: " + name + "[]");
                    fetch.add(new BodyFetchElement("BODY[" + parameter + "]", parameter, partial), true);
                }
            }
        }

        private char nextCharInLine(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextChar();
            if (next == '\r' || next == '\n') {
                throw new ProtocolException("Unexpected end of line.");
            }
            return next;
        }

        private char nextNonSpaceChar(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextChar();
            while (next == ' ') {
                request.consume();
                next = request.nextChar();
            }
            return next;
        }
    }
}

