/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.Flags;

public class CommandParser {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    public String atom(ImapRequestLineReader request) throws ProtocolException {
        return this.consumeWord(request, new ATOM_CHARValidator());
    }

    public String tag(ImapRequestLineReader request) throws ProtocolException {
        TagCharValidator validator = new TagCharValidator();
        return this.consumeWord(request, validator);
    }

    public String astring(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted(request);
            }
            case '{': {
                return this.consumeLiteral(request);
            }
        }
        return this.atom(request);
    }

    public String nstring(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return this.consumeQuoted(request);
            }
            case '{': {
                return this.consumeLiteral(request);
            }
        }
        String value = this.atom(request);
        if ("NIL".equals(value)) {
            return null;
        }
        throw new ProtocolException("Invalid nstring value: valid values are '\"...\"', '{12} CRLF *CHAR8', and 'NIL'.");
    }

    public String mailbox(ImapRequestLineReader request) throws ProtocolException {
        String mailbox = this.astring(request);
        if (mailbox.equalsIgnoreCase("INBOX")) {
            return "INBOX";
        }
        return mailbox;
    }

    public Date dateTime(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        if (next != '\"') {
            throw new ProtocolException("DateTime values must be quoted.");
        }
        String dateString = this.consumeQuoted(request);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss zzzz");
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new ProtocolException("Invalid date format.");
        }
    }

    public Date date(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextWordChar();
        String dateString = next == '\"' ? this.consumeQuoted(request) : this.atom(request);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new ProtocolException("Invalid date format.");
        }
    }

    protected String consumeWord(ImapRequestLineReader request, CharacterValidator validator) throws ProtocolException {
        StringBuffer atom = new StringBuffer();
        char next = request.nextWordChar();
        while (!this.isWhitespace(next)) {
            if (!validator.isValid(next)) {
                throw new ProtocolException("Invalid character: '" + next + "'");
            }
            atom.append(next);
            request.consume();
            next = request.nextChar();
        }
        return atom.toString();
    }

    private boolean isWhitespace(char next) {
        return next == ' ' || next == '\n' || next == '\r' || next == '\t';
    }

    protected String consumeLiteral(ImapRequestLineReader request) throws ProtocolException {
        this.consumeChar(request, '{');
        StringBuffer digits = new StringBuffer();
        char next = request.nextChar();
        while (next != '}' && next != '+') {
            digits.append(next);
            request.consume();
            next = request.nextChar();
        }
        boolean synchronizedLiteral = true;
        if (next == '+') {
            synchronizedLiteral = false;
            this.consumeChar(request, '+');
        }
        this.consumeChar(request, '}');
        this.consumeCRLF(request);
        if (synchronizedLiteral) {
            request.commandContinuationRequest();
        }
        int size = Integer.parseInt(digits.toString());
        byte[] buffer = new byte[size];
        request.read(buffer);
        return new String(buffer);
    }

    private void consumeCRLF(ImapRequestLineReader request) throws ProtocolException {
        char next = request.nextChar();
        if (next != '\n') {
            this.consumeChar(request, '\r');
        }
        this.consumeChar(request, '\n');
    }

    protected void consumeChar(ImapRequestLineReader request, char expected) throws ProtocolException {
        char consumed = request.consume();
        if (consumed != expected) {
            throw new ProtocolException("Expected:'" + expected + "' found:'" + consumed + "'");
        }
    }

    protected String consumeQuoted(ImapRequestLineReader request) throws ProtocolException {
        this.consumeChar(request, '\"');
        StringBuffer quoted = new StringBuffer();
        char next = request.nextChar();
        while (next != '\"') {
            if (next == '\\') {
                request.consume();
                next = request.nextChar();
                if (!this.isQuotedSpecial(next)) {
                    throw new ProtocolException("Invalid escaped character in quote: '" + next + "'");
                }
            }
            quoted.append(next);
            request.consume();
            next = request.nextChar();
        }
        this.consumeChar(request, '\"');
        return quoted.toString();
    }

    public byte[] base64(ImapRequestLineReader request) throws ProtocolException {
        return null;
    }

    public Flags flagList(ImapRequestLineReader request) throws ProtocolException {
        Flags flags = new Flags();
        request.nextWordChar();
        this.consumeChar(request, '(');
        NoopCharValidator validator = new NoopCharValidator();
        String nextWord = this.consumeWord(request, validator);
        while (!nextWord.endsWith(")")) {
            this.setFlag(nextWord, flags);
            nextWord = this.consumeWord(request, validator);
        }
        if (nextWord.length() > 1) {
            this.setFlag(nextWord.substring(0, nextWord.length() - 1), flags);
        }
        return flags;
    }

    public void setFlag(String flagString, Flags flags) throws ProtocolException {
        if (flagString.equalsIgnoreCase("\\ANSWERED")) {
            flags.add(Flags.Flag.ANSWERED);
        } else if (flagString.equalsIgnoreCase("\\DELETED")) {
            flags.add(Flags.Flag.DELETED);
        } else if (flagString.equalsIgnoreCase("\\DRAFT")) {
            flags.add(Flags.Flag.DRAFT);
        } else if (flagString.equalsIgnoreCase("\\FLAGGED")) {
            flags.add(Flags.Flag.FLAGGED);
        } else if (flagString.equalsIgnoreCase("\\SEEN")) {
            flags.add(Flags.Flag.SEEN);
        } else {
            throw new ProtocolException("Invalid flag string.");
        }
    }

    public long number(ImapRequestLineReader request) throws ProtocolException {
        String digits = this.consumeWord(request, new DigitCharValidator());
        return Long.parseLong(digits);
    }

    public long nzNumber(ImapRequestLineReader request) throws ProtocolException {
        long number = this.number(request);
        if (number == 0L) {
            throw new ProtocolException("Zero value not permitted.");
        }
        return number;
    }

    private boolean isCHAR(char chr) {
        return chr >= '\u0001' && chr <= '\u007f';
    }

    private boolean isCHAR8(char chr) {
        return chr >= '\u0001' && chr <= '\u00ff';
    }

    protected boolean isListWildcard(char chr) {
        return chr == '*' || chr == '%';
    }

    private boolean isQuotedSpecial(char chr) {
        return chr == '\"' || chr == '\\';
    }

    public void endLine(ImapRequestLineReader request) throws ProtocolException {
        request.eol();
    }

    public IdRange[] parseIdRange(ImapRequestLineReader request) throws ProtocolException {
        String range;
        MessageSetCharValidator validator = new MessageSetCharValidator();
        String nextWord = this.consumeWord(request, validator);
        int commaPos = nextWord.indexOf(44);
        if (commaPos == -1) {
            return new IdRange[]{this.parseRange(nextWord)};
        }
        ArrayList<IdRange> rangeList = new ArrayList<IdRange>();
        int pos = 0;
        while (commaPos != -1) {
            range = nextWord.substring(pos, commaPos);
            IdRange set = this.parseRange(range);
            rangeList.add(set);
            pos = commaPos + 1;
            commaPos = nextWord.indexOf(44, pos);
        }
        range = nextWord.substring(pos);
        rangeList.add(this.parseRange(range));
        return rangeList.toArray(new IdRange[rangeList.size()]);
    }

    private IdRange parseRange(String range) throws ProtocolException {
        int pos = range.indexOf(58);
        try {
            if (pos == -1) {
                long value = this.parseLong(range);
                return new IdRange(value);
            }
            long lowVal = this.parseLong(range.substring(0, pos));
            long highVal = this.parseLong(range.substring(pos + 1));
            return new IdRange(lowVal, highVal);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid message set.");
        }
    }

    private long parseLong(String value) {
        if (value.length() == 1 && value.charAt(0) == '*') {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(value);
    }

    private class MessageSetCharValidator
    implements CharacterValidator {
        private MessageSetCharValidator() {
        }

        public boolean isValid(char chr) {
            return this.isDigit(chr) || chr == ':' || chr == '*' || chr == ',';
        }

        private boolean isDigit(char chr) {
            return '0' <= chr && chr <= '9';
        }
    }

    private class TagCharValidator
    extends ATOM_CHARValidator {
        private TagCharValidator() {
        }

        public boolean isValid(char chr) {
            if (chr == '+') {
                return false;
            }
            return super.isValid(chr);
        }
    }

    protected class DigitCharValidator
    implements CharacterValidator {
        protected DigitCharValidator() {
        }

        public boolean isValid(char chr) {
            return chr >= '0' && chr <= '9' || chr == '*';
        }
    }

    protected class ATOM_CHARValidator
    implements CharacterValidator {
        protected ATOM_CHARValidator() {
        }

        public boolean isValid(char chr) {
            return CommandParser.this.isCHAR(chr) && !this.isAtomSpecial(chr) && !CommandParser.this.isListWildcard(chr) && !CommandParser.this.isQuotedSpecial(chr);
        }

        private boolean isAtomSpecial(char chr) {
            return chr == '(' || chr == ')' || chr == '{' || chr == ' ' || chr == '\u000f';
        }
    }

    protected class NoopCharValidator
    implements CharacterValidator {
        protected NoopCharValidator() {
        }

        public boolean isValid(char chr) {
            return true;
        }
    }

    protected static interface CharacterValidator {
        public boolean isValid(char var1);
    }
}

