/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.ArgumentTypeResolver;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.DeclaringTypeResolver;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.MethodNameEqualityResolver;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.ParameterLengthResolver;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.BindingPriority;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public interface MethodDelegationBinder {
    public MethodBinding bind(Implementation.Target var1, MethodDescription var2, MethodDescription var3);

    public static class Processor {
        private static final int ONLY = 0;
        private static final int LEFT = 0;
        private static final int RIGHT = 1;
        private final MethodDelegationBinder methodDelegationBinder;
        private final AmbiguityResolver ambiguityResolver;

        public Processor(MethodDelegationBinder methodDelegationBinder, AmbiguityResolver ambiguityResolver) {
            this.methodDelegationBinder = methodDelegationBinder;
            this.ambiguityResolver = ambiguityResolver;
        }

        public MethodBinding process(Implementation.Target implementationTarget, MethodDescription source, MethodList<?> targetCandidates) {
            List<MethodBinding> possibleDelegations = this.bind(implementationTarget, source, targetCandidates);
            if (possibleDelegations.isEmpty()) {
                throw new IllegalArgumentException("None of " + targetCandidates + " allows for delegation from " + source);
            }
            return this.resolve(source, possibleDelegations);
        }

        private List<MethodBinding> bind(Implementation.Target implementationTarget, MethodDescription source, MethodList<?> targetCandidates) {
            ArrayList<MethodBinding> possibleDelegations = new ArrayList<MethodBinding>();
            for (MethodDescription targetCandidate : (MethodList)targetCandidates.filter(ElementMatchers.isVisibleTo(implementationTarget.getInstrumentedType()))) {
                MethodBinding methodBinding = this.methodDelegationBinder.bind(implementationTarget, source, targetCandidate);
                if (!methodBinding.isValid()) continue;
                possibleDelegations.add(methodBinding);
            }
            return possibleDelegations;
        }

        private MethodBinding resolve(MethodDescription source, List<MethodBinding> targets) {
            switch (targets.size()) {
                case 1: {
                    return targets.get(0);
                }
                case 2: {
                    MethodBinding left = targets.get(0);
                    MethodBinding right = targets.get(1);
                    switch (this.ambiguityResolver.resolve(source, left, right)) {
                        case LEFT: {
                            return left;
                        }
                        case RIGHT: {
                            return right;
                        }
                        case UNKNOWN: 
                        case AMBIGUOUS: {
                            throw new IllegalArgumentException("Cannot resolve ambiguous delegation of " + source + " to " + left + " or " + right);
                        }
                    }
                    throw new AssertionError();
                }
            }
            MethodBinding left = targets.get(0);
            MethodBinding right = targets.get(1);
            switch (this.ambiguityResolver.resolve(source, left, right)) {
                case LEFT: {
                    targets.remove(1);
                    return this.resolve(source, targets);
                }
                case RIGHT: {
                    targets.remove(0);
                    return this.resolve(source, targets);
                }
                case UNKNOWN: 
                case AMBIGUOUS: {
                    targets.remove(1);
                    targets.remove(0);
                    MethodBinding subResult = this.resolve(source, targets);
                    switch (this.ambiguityResolver.resolve(source, left, subResult).merge(this.ambiguityResolver.resolve(source, right, subResult))) {
                        case RIGHT: {
                            return subResult;
                        }
                        case UNKNOWN: 
                        case AMBIGUOUS: 
                        case LEFT: {
                            throw new IllegalArgumentException("Cannot resolve ambiguous delegation of " + source + " to " + left + " or " + right);
                        }
                    }
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.ambiguityResolver.equals(((Processor)other).ambiguityResolver) && this.methodDelegationBinder.equals(((Processor)other).methodDelegationBinder);
        }

        public int hashCode() {
            return 31 * this.methodDelegationBinder.hashCode() + this.ambiguityResolver.hashCode();
        }

        public String toString() {
            return "MethodDelegationBinder.Processor{methodDelegationBinder=" + this.methodDelegationBinder + ", ambiguityResolver=" + this.ambiguityResolver + '}';
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="No circularity, initialization is safe")
    public static interface AmbiguityResolver {
        public static final AmbiguityResolver DEFAULT = new Chain(BindingPriority.Resolver.INSTANCE, DeclaringTypeResolver.INSTANCE, ArgumentTypeResolver.INSTANCE, MethodNameEqualityResolver.INSTANCE, ParameterLengthResolver.INSTANCE);

        public Resolution resolve(MethodDescription var1, MethodBinding var2, MethodBinding var3);

        public static class Chain
        implements AmbiguityResolver {
            private final List<? extends AmbiguityResolver> ambiguityResolvers;

            public Chain(AmbiguityResolver ... ambiguityResolver) {
                this(Arrays.asList(ambiguityResolver));
            }

            public Chain(List<? extends AmbiguityResolver> ambiguityResolvers) {
                this.ambiguityResolvers = ambiguityResolvers;
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                Resolution resolution = Resolution.UNKNOWN;
                Iterator<? extends AmbiguityResolver> iterator = this.ambiguityResolvers.iterator();
                while (resolution.isUnresolved() && iterator.hasNext()) {
                    resolution = iterator.next().resolve(source, left, right);
                }
                return resolution;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.ambiguityResolvers.equals(((Chain)other).ambiguityResolvers);
            }

            public int hashCode() {
                return this.ambiguityResolvers.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Chain{ambiguityResolvers=" + this.ambiguityResolvers + '}';
            }
        }

        public static enum Directional implements AmbiguityResolver
        {
            LEFT(true),
            RIGHT(false);

            private final boolean left;

            private Directional(boolean left) {
                this.left = left;
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return this.left ? Resolution.LEFT : Resolution.RIGHT;
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Directional." + this.name();
            }
        }

        public static enum NoOp implements AmbiguityResolver
        {
            INSTANCE;


            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return Resolution.UNKNOWN;
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.NoOp." + this.name();
            }
        }

        public static enum Resolution {
            UNKNOWN(true),
            LEFT(false),
            RIGHT(false),
            AMBIGUOUS(true);

            private final boolean unresolved;

            private Resolution(boolean unresolved) {
                this.unresolved = unresolved;
            }

            public boolean isUnresolved() {
                return this.unresolved;
            }

            public Resolution merge(Resolution other) {
                switch (this) {
                    case UNKNOWN: {
                        return other;
                    }
                    case AMBIGUOUS: {
                        return AMBIGUOUS;
                    }
                    case LEFT: 
                    case RIGHT: {
                        return other == this ? this : AMBIGUOUS;
                    }
                }
                throw new AssertionError();
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Resolution." + this.name();
            }
        }
    }

    public static interface MethodBinding
    extends StackManipulation {
        public Integer getTargetParameterIndex(Object var1);

        public MethodDescription getTarget();

        public static class Builder {
            private final MethodInvoker methodInvoker;
            private final MethodDescription target;
            private final List<StackManipulation> parameterStackManipulations;
            private final LinkedHashMap<Object, Integer> registeredTargetIndices;
            private int nextParameterIndex;

            public Builder(MethodInvoker methodInvoker, MethodDescription target) {
                this.methodInvoker = methodInvoker;
                this.target = target;
                this.parameterStackManipulations = new ArrayList<StackManipulation>(target.getParameters().size());
                this.registeredTargetIndices = new LinkedHashMap();
                this.nextParameterIndex = 0;
            }

            public boolean append(ParameterBinding<?> parameterBinding) {
                this.parameterStackManipulations.add(parameterBinding);
                return this.registeredTargetIndices.put(parameterBinding.getIdentificationToken(), this.nextParameterIndex++) == null;
            }

            public MethodBinding build(StackManipulation terminatingManipulation) {
                if (this.target.getParameters().size() != this.nextParameterIndex) {
                    throw new IllegalStateException("The number of parameters bound does not equal the target's number of parameters");
                }
                return new Build(this.target, this.registeredTargetIndices, this.methodInvoker.invoke(this.target), this.parameterStackManipulations, terminatingManipulation);
            }

            public int getNextParameterIndex() {
                return this.nextParameterIndex;
            }

            public String toString() {
                return "MethodDelegationBinder.MethodBinding.Builder{methodInvoker=" + this.methodInvoker + ", target=" + this.target + ", parameterStackManipulations=" + this.parameterStackManipulations + ", registeredTargetIndices=" + this.registeredTargetIndices + ", nextParameterIndex=" + this.nextParameterIndex + '}';
            }

            protected static class Build
            implements MethodBinding {
                private final MethodDescription target;
                private final Map<?, Integer> registeredTargetIndices;
                private final StackManipulation methodInvocation;
                private final List<StackManipulation> parameterStackManipulations;
                private final StackManipulation terminatingStackManipulation;

                protected Build(MethodDescription target, Map<?, Integer> registeredTargetIndices, StackManipulation methodInvocation, List<StackManipulation> parameterStackManipulations, StackManipulation terminatingStackManipulation) {
                    this.target = target;
                    this.registeredTargetIndices = new HashMap(registeredTargetIndices);
                    this.methodInvocation = methodInvocation;
                    this.parameterStackManipulations = new ArrayList<StackManipulation>(parameterStackManipulations);
                    this.terminatingStackManipulation = terminatingStackManipulation;
                }

                @Override
                public boolean isValid() {
                    boolean result = this.methodInvocation.isValid() && this.terminatingStackManipulation.isValid();
                    Iterator<StackManipulation> assignment = this.parameterStackManipulations.iterator();
                    while (result && assignment.hasNext()) {
                        result = assignment.next().isValid();
                    }
                    return result;
                }

                @Override
                public Integer getTargetParameterIndex(Object parameterBindingToken) {
                    return this.registeredTargetIndices.get(parameterBindingToken);
                }

                @Override
                public MethodDescription getTarget() {
                    return this.target;
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    StackManipulation.Size size = new StackManipulation.Size(0, 0);
                    for (StackManipulation stackManipulation : this.parameterStackManipulations) {
                        size = size.aggregate(stackManipulation.apply(methodVisitor, implementationContext));
                    }
                    size = size.aggregate(this.methodInvocation.apply(methodVisitor, implementationContext));
                    return size.aggregate(this.terminatingStackManipulation.apply(methodVisitor, implementationContext));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Build build = (Build)other;
                    return this.methodInvocation.equals(build.methodInvocation) && this.parameterStackManipulations.equals(build.parameterStackManipulations) && this.registeredTargetIndices.equals(build.registeredTargetIndices) && this.terminatingStackManipulation.equals(build.terminatingStackManipulation) && this.target.equals(build.target);
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.registeredTargetIndices.hashCode();
                    result = 31 * result + this.methodInvocation.hashCode();
                    result = 31 * result + this.parameterStackManipulations.hashCode();
                    result = 31 * result + this.terminatingStackManipulation.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodDelegationBinder.MethodBinding.Builder.Build{target=" + this.target + ", registeredTargetIndices=" + this.registeredTargetIndices + ", methodInvocation=" + this.methodInvocation + ", parameterStackManipulations=" + this.parameterStackManipulations + ", terminatingStackManipulation=" + this.terminatingStackManipulation + '}';
                }
            }
        }

        public static enum Illegal implements MethodBinding
        {
            INSTANCE;


            @Override
            public Integer getTargetParameterIndex(Object parameterBindingToken) {
                throw new IllegalStateException("Method is not bound");
            }

            @Override
            public MethodDescription getTarget() {
                throw new IllegalStateException("Method is not bound");
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                throw new IllegalStateException("Cannot delegate to an unbound method");
            }

            public String toString() {
                return "MethodDelegationBinder.MethodBinding.Illegal." + this.name();
            }
        }
    }

    public static interface ParameterBinding<T>
    extends StackManipulation {
        public T getIdentificationToken();

        public static class Unique<T>
        implements ParameterBinding<T> {
            private final T identificationToken;
            private final StackManipulation delegate;

            public Unique(StackManipulation delegate, T identificationToken) {
                this.delegate = delegate;
                this.identificationToken = identificationToken;
            }

            public static <S> Unique<S> of(StackManipulation delegate, S identificationToken) {
                return new Unique<S>(delegate, identificationToken);
            }

            @Override
            public T getIdentificationToken() {
                return this.identificationToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                return this.delegate.apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Unique unique = (Unique)other;
                return this.identificationToken.equals(unique.identificationToken) && this.delegate.equals(unique.delegate);
            }

            public int hashCode() {
                int result = this.identificationToken.hashCode();
                result = 31 * result + this.delegate.hashCode();
                return result;
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Unique{identificationToken=" + this.identificationToken + ", delegate=" + this.delegate + '}';
            }
        }

        public static class Anonymous
        implements ParameterBinding<Object> {
            private final Object anonymousToken;
            private final StackManipulation delegate;

            public Anonymous(StackManipulation delegate) {
                this.delegate = delegate;
                this.anonymousToken = new Object();
            }

            @Override
            public Object getIdentificationToken() {
                return this.anonymousToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                return this.delegate.apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.delegate.equals(((Anonymous)other).delegate);
            }

            public int hashCode() {
                return 31 * this.delegate.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Anonymous{anonymousToken=" + this.anonymousToken + ", delegate=" + this.delegate + '}';
            }
        }

        public static enum Illegal implements ParameterBinding<Void>
        {
            INSTANCE;


            @Override
            public Void getIdentificationToken() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                throw new IllegalStateException("An illegal parameter binding must not be applied");
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Illegal." + this.name();
            }
        }
    }

    public static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1);

        public static class Virtual
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            public Virtual(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription).virtual(this.typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Virtual)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.MethodInvoker.Virtual{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static enum Simple implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription);
            }

            public String toString() {
                return "MethodDelegationBinder.MethodInvoker.Simple." + this.name();
            }
        }
    }
}

