/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class GzipHandlerBreakEvenSizeTest {
    private Server server;
    private HttpClient client;

    @BeforeEach
    public void startServerAndClient() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setExcludedAgentPatterns(new String[0]);
        gzipHandler.setMinGzipSize(0);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)gzipHandler, "/");
        context.addServlet(VeryCompressibleContentServlet.class, "/content");
        gzipHandler.setHandler((Handler)context);
        this.server.setHandler((Handler)gzipHandler);
        this.server.start();
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterEach
    public void stopServerAndClient() {
        LifeCycle.stop((Object)this.client);
        LifeCycle.stop((Object)this.server);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4, 5, 10, 15, 20, 21, 22, 23, 24, 25, 50, 100, 300, 500})
    public void testRequestSized(int size) throws Exception {
        URI uri = this.server.getURI().resolve("/content?size=" + size);
        ContentResponse response = this.client.newRequest(uri).header(HttpHeader.ACCEPT_ENCODING, "gzip").send();
        MatcherAssert.assertThat((String)"Status Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Size Requested", (Object)response.getHeaders().getField("X-SizeRequested").getIntValue(), (Matcher)Matchers.is((Object)size));
        if (size > 23) {
            MatcherAssert.assertThat((String)"Response Size", (Object)response.getHeaders().getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(size)));
        }
    }

    public static class VeryCompressibleContentServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("utf-8");
            String sizeStr = req.getParameter("size");
            int size = 0;
            if (!StringUtil.isBlank((String)sizeStr)) {
                size = Integer.parseInt(sizeStr);
            }
            resp.setHeader("X-SizeRequested", String.valueOf(size));
            if (size > 0) {
                byte[] buf = new byte[size];
                Arrays.fill(buf, (byte)120);
                resp.getWriter().print(new String(buf, StandardCharsets.UTF_8));
            }
            resp.getWriter().close();
        }
    }
}

