/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultHandlerTest {
    private Server server;
    private LocalConnector localConnector;
    private File baseA;
    private File baseFoo;

    @BeforeEach
    public void startServer() throws Exception {
        this.server = new Server();
        this.localConnector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.localConnector);
        File docRoot = MavenTestingUtils.getTargetTestingDir((String)DefaultHandlerTest.class.getName());
        FS.ensureDirExists((File)docRoot);
        this.baseA = new File(docRoot, "baseA");
        FS.ensureDirExists((File)this.baseA);
        this.baseFoo = new File(docRoot, "baseFoo");
        FS.ensureDirExists((File)this.baseFoo);
        ServletContextHandler contextA = new ServletContextHandler();
        contextA.setContextPath("/a");
        contextA.setBaseResource((Resource)new PathResource(this.baseA));
        ServletContextHandler contextFoo = new ServletContextHandler();
        contextFoo.setContextPath("/foo");
        contextFoo.setBaseResource((Resource)new PathResource(this.baseFoo));
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)contextA);
        handlers.addHandler((Handler)contextFoo);
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.server.stop();
    }

    @Test
    public void testNotRevealBaseResource() throws Exception {
        StringBuilder req = new StringBuilder();
        req.append("GET / HTTP/1.0\r\n");
        req.append("\r\n");
        String rawResponse = this.localConnector.getResponses(req.toString());
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"404 Not Found"));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"No context on this server matched or handled this request"));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"Contexts known to this server are"));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"<a href=\"/a/\">"));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"<a href=\"/foo/\">"));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.baseA.toString())));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.baseFoo.toString())));
    }
}

