/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.PathMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathMapTest {
    @Test
    public void testPathMap() throws Exception {
        String[][] tests;
        PathMap p = new PathMap();
        p.put("/abs/path", (Object)"1");
        p.put("/abs/path/longer", (Object)"2");
        p.put("/animal/bird/*", (Object)"3");
        p.put("/animal/fish/*", (Object)"4");
        p.put("/animal/*", (Object)"5");
        p.put("*.tar.gz", (Object)"6");
        p.put("*.gz", (Object)"7");
        p.put("/", (Object)"8");
        p.put("/XXX:/YYY", (Object)"9");
        p.put("", (Object)"10");
        p.put("/\u20acuro/*", (Object)"11");
        for (String[] test : tests = new String[][]{{"/abs/path", "1"}, {"/abs/path/xxx", "8"}, {"/abs/pith", "8"}, {"/abs/path/longer", "2"}, {"/abs/path/", "8"}, {"/abs/path/xxx", "8"}, {"/animal/bird/eagle/bald", "3"}, {"/animal/fish/shark/grey", "4"}, {"/animal/insect/bug", "5"}, {"/animal", "5"}, {"/animal/", "5"}, {"/animal/x", "5"}, {"/animal/*", "5"}, {"/suffix/path.tar.gz", "6"}, {"/suffix/path.gz", "7"}, {"/animal/path.gz", "5"}, {"/Other/path", "8"}, {"/\u20acuro/path", "11"}, {"/", "10"}}) {
            Assertions.assertEquals((Object)test[1], (Object)p.getMatch(test[0]).getValue(), (String)test[0]);
        }
        Assertions.assertEquals((Object)"1", (Object)p.get((Object)"/abs/path"), (String)"Get absolute path");
        Assertions.assertEquals((Object)"/abs/path", (Object)p.getMatch("/abs/path").getKey(), (String)"Match absolute path");
        Assertions.assertEquals((Object)"[/animal/bird/*=3, /animal/*=5, *.tar.gz=6, *.gz=7, /=8]", (Object)p.getMatches("/animal/bird/path.tar.gz").toString(), (String)"all matches");
        Assertions.assertEquals((Object)"[/animal/fish/*=4, /animal/*=5, /=8]", (Object)p.getMatches("/animal/fish/").toString(), (String)"Dir matches");
        Assertions.assertEquals((Object)"[/animal/fish/*=4, /animal/*=5, /=8]", (Object)p.getMatches("/animal/fish").toString(), (String)"Dir matches");
        Assertions.assertEquals((Object)"[=10, /=8]", (Object)p.getMatches("/").toString(), (String)"Root matches");
        Assertions.assertEquals((Object)"[/=8]", (Object)p.getMatches("").toString(), (String)"Dir matches");
        Assertions.assertEquals((Object)"/Foo/bar", (Object)PathMap.pathMatch((String)"/Foo/bar", (String)"/Foo/bar"), (String)"pathMatch exact");
        Assertions.assertEquals((Object)"/Foo", (Object)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo/bar"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo", (Object)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo/"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo", (Object)PathMap.pathMatch((String)"/Foo/*", (String)"/Foo"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo/bar.ext", (Object)PathMap.pathMatch((String)"*.ext", (String)"/Foo/bar.ext"), (String)"pathMatch suffix");
        Assertions.assertEquals((Object)"/Foo/bar.ext", (Object)PathMap.pathMatch((String)"/", (String)"/Foo/bar.ext"), (String)"pathMatch default");
        Assertions.assertEquals(null, (Object)PathMap.pathInfo((String)"/Foo/bar", (String)"/Foo/bar"), (String)"pathInfo exact");
        Assertions.assertEquals((Object)"/bar", (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/bar"), (String)"pathInfo prefix");
        Assertions.assertEquals((Object)"/*", (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/*"), (String)"pathInfo prefix");
        Assertions.assertEquals((Object)"/", (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo/"), (String)"pathInfo prefix");
        Assertions.assertEquals(null, (Object)PathMap.pathInfo((String)"/Foo/*", (String)"/Foo"), (String)"pathInfo prefix");
        Assertions.assertEquals(null, (Object)PathMap.pathInfo((String)"*.ext", (String)"/Foo/bar.ext"), (String)"pathInfo suffix");
        Assertions.assertEquals(null, (Object)PathMap.pathInfo((String)"/", (String)"/Foo/bar.ext"), (String)"pathInfo default");
        Assertions.assertEquals((Object)"9", (Object)p.getMatch("/XXX").getValue(), (String)"multi paths");
        Assertions.assertEquals((Object)"9", (Object)p.getMatch("/YYY").getValue(), (String)"multi paths");
        p.put("/*", (Object)"0");
        Assertions.assertEquals((Object)"1", (Object)p.get((Object)"/abs/path"), (String)"Get absolute path");
        Assertions.assertEquals((Object)"/abs/path", (Object)p.getMatch("/abs/path").getKey(), (String)"Match absolute path");
        Assertions.assertEquals((Object)"1", (Object)p.getMatch("/abs/path").getValue(), (String)"Match absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/path/xxx").getValue(), (String)"Mismatch absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/pith").getValue(), (String)"Mismatch absolute path");
        Assertions.assertEquals((Object)"2", (Object)p.getMatch("/abs/path/longer").getValue(), (String)"Match longer absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/path/").getValue(), (String)"Not exact absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/abs/path/xxx").getValue(), (String)"Not exact absolute path");
        Assertions.assertEquals((Object)"3", (Object)p.getMatch("/animal/bird/eagle/bald").getValue(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"4", (Object)p.getMatch("/animal/fish/shark/grey").getValue(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal/insect/bug").getValue(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal").getValue(), (String)"mismatch exact prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal/").getValue(), (String)"mismatch exact prefix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/suffix/path.tar.gz").getValue(), (String)"Match longest suffix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/suffix/path.gz").getValue(), (String)"Match longest suffix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatch("/animal/path.gz").getValue(), (String)"prefix rather than suffix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatch("/Other/path").getValue(), (String)"default");
        Assertions.assertEquals((Object)"", (Object)PathMap.pathMatch((String)"/*", (String)"/xxx/zzz"), (String)"pathMatch /*");
        Assertions.assertEquals((Object)"/xxx/zzz", (Object)PathMap.pathInfo((String)"/*", (String)"/xxx/zzz"), (String)"pathInfo /*");
        Assertions.assertTrue((boolean)PathMap.match((String)"/", (String)"/anything"), (String)"match /");
        Assertions.assertTrue((boolean)PathMap.match((String)"/*", (String)"/anything"), (String)"match /*");
        Assertions.assertTrue((boolean)PathMap.match((String)"/foo", (String)"/foo"), (String)"match /foo");
        Assertions.assertTrue((!PathMap.match((String)"/foo", (String)"/bar") ? 1 : 0) != 0, (String)"!match /foo");
        Assertions.assertTrue((boolean)PathMap.match((String)"/foo/*", (String)"/foo"), (String)"match /foo/*");
        Assertions.assertTrue((boolean)PathMap.match((String)"/foo/*", (String)"/foo/"), (String)"match /foo/*");
        Assertions.assertTrue((boolean)PathMap.match((String)"/foo/*", (String)"/foo/anything"), (String)"match /foo/*");
        Assertions.assertTrue((!PathMap.match((String)"/foo/*", (String)"/bar") ? 1 : 0) != 0, (String)"!match /foo/*");
        Assertions.assertTrue((!PathMap.match((String)"/foo/*", (String)"/bar/") ? 1 : 0) != 0, (String)"!match /foo/*");
        Assertions.assertTrue((!PathMap.match((String)"/foo/*", (String)"/bar/anything") ? 1 : 0) != 0, (String)"!match /foo/*");
        Assertions.assertTrue((boolean)PathMap.match((String)"*.foo", (String)"anything.foo"), (String)"match *.foo");
        Assertions.assertTrue((!PathMap.match((String)"*.foo", (String)"anything.bar") ? 1 : 0) != 0, (String)"!match *.foo");
        Assertions.assertEquals((Object)"10", (Object)p.getMatch("/").getValue(), (String)"match / with ''");
        Assertions.assertTrue((boolean)PathMap.match((String)"", (String)"/"), (String)"match \"\"");
    }

    @Test
    public void testPathMappingsOnlyMatchOnDirectoryNames() throws Exception {
        String spec = "/xyz/*";
        this.assertMatch(spec, "/xyz");
        this.assertMatch(spec, "/xyz/");
        this.assertMatch(spec, "/xyz/123");
        this.assertMatch(spec, "/xyz/123/");
        this.assertMatch(spec, "/xyz/123.txt");
        this.assertNotMatch(spec, "/xyz123");
        this.assertNotMatch(spec, "/xyz123;jessionid=99");
        this.assertNotMatch(spec, "/xyz123/");
        this.assertNotMatch(spec, "/xyz123/456");
        this.assertNotMatch(spec, "/xyz.123");
        this.assertNotMatch(spec, "/xyz;123");
        this.assertNotMatch(spec, "/xyz?123");
    }

    @Test
    public void testPrecidenceVsOrdering() throws Exception {
        PathMap p = new PathMap();
        p.put("/dump/gzip/*", (Object)"prefix");
        p.put("*.txt", (Object)"suffix");
        Assertions.assertEquals(null, (Object)p.getMatch("/foo/bar"));
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something").getValue());
        Assertions.assertEquals((Object)"suffix", (Object)p.getMatch("/foo/something.txt").getValue());
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something.txt").getValue());
        p = new PathMap();
        p.put("*.txt", (Object)"suffix");
        p.put("/dump/gzip/*", (Object)"prefix");
        Assertions.assertEquals(null, (Object)p.getMatch("/foo/bar"));
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something").getValue());
        Assertions.assertEquals((Object)"suffix", (Object)p.getMatch("/foo/something.txt").getValue());
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatch("/dump/gzip/something.txt").getValue());
    }

    private void assertMatch(String spec, String path) {
        boolean match = PathMap.match((String)spec, (String)path);
        Assertions.assertTrue((boolean)match, (String)("PathSpec '" + spec + "' should match path '" + path + "'"));
    }

    private void assertNotMatch(String spec, String path) {
        boolean match = PathMap.match((String)spec, (String)path);
        Assertions.assertFalse((boolean)match, (String)("PathSpec '" + spec + "' should not match path '" + path + "'"));
    }
}

