/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Array;

public final class ArgumentToString {
    private ArgumentToString() {
    }

    public static void appendArgument(Object value, StringBuffer buffer) {
        if (value == null) {
            buffer.append("null");
        } else if (value instanceof String) {
            buffer.append("\"");
            buffer.append(value);
            buffer.append("\"");
        } else if (value instanceof Character) {
            buffer.append("'");
            buffer.append(value);
            buffer.append("'");
        } else if (value.getClass().isArray()) {
            buffer.append("[");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                ArgumentToString.appendArgument(Array.get(value, i), buffer);
            }
            buffer.append("]");
        } else {
            buffer.append(value);
        }
    }

    public static String argumentToString(Object argument) {
        StringBuffer result = new StringBuffer();
        ArgumentToString.appendArgument(argument, result);
        return result.toString();
    }

    public static String argumentsToString(Object ... arguments) {
        if (arguments == null) {
            arguments = new Object[]{};
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(ArgumentToString.argumentToString(arguments[i]));
        }
        return result.toString();
    }
}

