/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.h2.java.JavaParser;
import org.h2.test.TestBase;

public class Test
extends TestBase {
    public static void main(String ... stringArray) throws IOException {
        new Test().test();
    }

    public void test() throws IOException {
        this.assertEquals("\\\\u0000", JavaParser.replaceUnicode("\\\\u0000"));
        this.assertEquals("\u0000", JavaParser.replaceUnicode("\\u0000"));
        this.assertEquals("\u0000", JavaParser.replaceUnicode("\\uu0000"));
        this.assertEquals("\\\\\u0000", JavaParser.replaceUnicode("\\\\\\u0000"));
        this.assertEquals("0", JavaParser.readNumber("0a"));
        this.assertEquals("0l", JavaParser.readNumber("0l"));
        this.assertEquals("0xFFL", JavaParser.readNumber("0xFFLx"));
        this.assertEquals("0xDadaCafe", JavaParser.readNumber("0xDadaCafex"));
        this.assertEquals("1.40e-45f", JavaParser.readNumber("1.40e-45fx"));
        this.assertEquals("1e1f", JavaParser.readNumber("1e1fx"));
        this.assertEquals("2.f", JavaParser.readNumber("2.fx"));
        this.assertEquals(".3d", JavaParser.readNumber(".3dx"));
        this.assertEquals("6.022137e+23f", JavaParser.readNumber("6.022137e+23f+1"));
        JavaParser javaParser = new JavaParser();
        javaParser.parse("src/tools/org/h2", "java.lang.Object");
        javaParser.parse("src/tools/org/h2", "java.lang.String");
        javaParser.parse("src/tools/org/h2", "java.io.PrintStream");
        javaParser.parse("src/tools/org/h2", "java.lang.System");
        javaParser.parse("src/tools/org/h2", "java.util.Arrays");
        javaParser.parse("src/tools", "org.h2.java.TestApp");
        PrintWriter printWriter = new PrintWriter(System.out);
        javaParser.writeHeader(printWriter);
        javaParser.writeSource(printWriter);
        printWriter.flush();
        printWriter = new PrintWriter(new FileWriter("bin/test.c"));
        javaParser.writeHeader(printWriter);
        javaParser.writeSource(printWriter);
        printWriter.close();
    }
}

